/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.http;

import javax.jms.JMSException;
import javax.servlet.ServletException;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.BrokerContext;
import org.activemq.spring.SpringBrokerContainerFactory;
import org.activemq.transport.TransportChannelListener;
import org.activemq.transport.TransportServerChannel;
import org.activemq.transport.TransportServerChannelSupport;
import org.activemq.transport.http.HttpTunnelServlet;
import org.activemq.util.IdGenerator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class HttpSpringEmbeddedTunnelServlet
extends HttpTunnelServlet {
    private static final long serialVersionUID = 8943695476238731241L;
    private BrokerContainer broker;
    private ServletConnector transportConnector;

    public synchronized void init() throws ServletException {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        try {
            this.broker.start();
        }
        catch (JMSException e) {
            throw new ServletException("Failed to start embedded broker: " + (Object)((Object)e), (Throwable)e);
        }
        TransportChannelListener listener = this.transportConnector.getTransportChannelListener();
        this.getServletContext().setAttribute("transportChannelListener", (Object)listener);
        super.init();
    }

    protected BrokerContainer createBroker() {
        String configFile = this.getServletContext().getInitParameter("org.activemq.config.file");
        if (configFile == null) {
            configFile = "activemq.xml";
        }
        SpringBrokerContainerFactory factory = new SpringBrokerContainerFactory();
        System.out.println("Loading Mesaage Broker from " + configFile + " on the CLASSPATH");
        factory.setResource((Resource)new ClassPathResource(configFile));
        IdGenerator idgen = new IdGenerator();
        BrokerContainer answer = factory.createBrokerContainer(idgen.generateId(), BrokerContext.getInstance());
        this.transportConnector = new ServletConnector(this.getConnectorURL());
        answer.addConnector((TransportServerChannel)this.transportConnector);
        return answer;
    }

    protected String getConnectorURL() {
        return "http://localhost/" + this.getServletContext().getServletContextName();
    }

    protected static class ServletConnector
    extends TransportServerChannelSupport {
        public ServletConnector(String url) {
            super(url);
        }
    }
}

