/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.identity;

import com.sun.org.apache.xerces.internal.impl.xpath.XPath;
import com.sun.org.apache.xerces.internal.impl.xpath.XPathException;
import com.sun.org.apache.xerces.internal.impl.xs.identity.Field;
import com.sun.org.apache.xerces.internal.impl.xs.identity.FieldActivator;
import com.sun.org.apache.xerces.internal.impl.xs.identity.IdentityConstraint;
import com.sun.org.apache.xerces.internal.impl.xs.identity.XPathMatcher;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;
    protected IdentityConstraint fIDConstraint;

    public com.sun.org.apache.xerces.internal.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIdentityConstraint;
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public Selector(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator activator, int initialDepth) {
        return new Matcher(this.fXPath, activator, initialDepth);
    }

    public class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fInitialDepth;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public int getInitialDepth() {
            return this.fInitialDepth;
        }

        public void startDocumentFragment() {
            super.startDocumentFragment();
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public IdentityConstraint getIdentityConstraint() {
            return Selector.this.fIdentityConstraint;
        }

        public void startElement(QName element, XMLAttributes attributes) {
            super.startElement(element, attributes);
            ++this.fElementDepth;
            if (this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
                int count = Selector.this.fIdentityConstraint.getFieldCount();
                int i = 0;
                while (i < count) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(i);
                    XPathMatcher matcher = this.fFieldActivator.activateField(field, this.fInitialDepth);
                    matcher.startElement(element, attributes);
                    ++i;
                }
            }
        }

        public Matcher(XPath xpath, FieldActivator activator, int initialDepth) {
            super(xpath);
            this.fFieldActivator = activator;
            this.fInitialDepth = initialDepth;
        }

        public void endElement(QName element, XSTypeDefinition type, boolean nillable, Object actualValue) {
            super.endElement(element, type, nillable, actualValue);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
            }
        }
    }

    public static class XPath
    extends com.sun.org.apache.xerces.internal.impl.xpath.XPath {
        private static String normalize(String xpath) {
            StringBuffer modifiedXPath = new StringBuffer(xpath.length() + 5);
            int unionIndex = -1;
            while (true) {
                if (!xpath.trim().startsWith("/") && !xpath.trim().startsWith(".")) {
                    modifiedXPath.append("./");
                }
                if ((unionIndex = xpath.indexOf(124)) == -1) break;
                modifiedXPath.append(xpath.substring(0, unionIndex + 1));
                xpath = xpath.substring(unionIndex + 1, xpath.length());
            }
            modifiedXPath.append(xpath);
            return modifiedXPath.toString();
        }

        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(XPath.normalize(xpath), symbolTable, context);
            int i = 0;
            while (i < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[i].steps[this.fLocationPaths[i].steps.length - 1].axis;
                if (axis.type == 2) {
                    throw new XPathException("c-selector-xpath");
                }
                ++i;
            }
        }
    }
}

