/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.XSConstraints;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.xni.QName;
import java.util.Vector;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private static final short STATE_CHILD = 1;
    private XSElementDecl[] fAllElements;
    private boolean[] fIsOptionalElement;
    private boolean fHasOptionalContent = false;
    private int fNumElements = 0;

    public int[] startContentModel() {
        int[] state = new int[this.fNumElements + 1];
        int i = 0;
        while (i <= this.fNumElements) {
            state[i] = 0;
            ++i;
        }
        return state;
    }

    public XSAllCM(boolean hasOptionalContent, int size) {
        this.fHasOptionalContent = hasOptionalContent;
        this.fAllElements = new XSElementDecl[size];
        this.fIsOptionalElement = new boolean[size];
    }

    public boolean endContentModel(int[] currentState) {
        int state = currentState[0];
        if (state == -1 || state == -2) {
            return false;
        }
        if (this.fHasOptionalContent && state == 0) {
            return true;
        }
        int i = 0;
        while (i < this.fNumElements) {
            if (!this.fIsOptionalElement[i] && currentState[i + 1] == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler) throws XMLSchemaException {
        int i = 0;
        while (i < this.fNumElements) {
            int j = i + 1;
            while (j < this.fNumElements) {
                if (XSConstraints.overlapUPA(this.fAllElements[i], this.fAllElements[j], subGroupHandler)) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[i].toString(), this.fAllElements[j].toString()});
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void addElement(XSElementDecl element, boolean isOptional) {
        this.fAllElements[this.fNumElements] = element;
        this.fIsOptionalElement[this.fNumElements] = isOptional;
        ++this.fNumElements;
    }

    public Vector whatCanGoHere(int[] state) {
        Vector<XSElementDecl> ret = new Vector<XSElementDecl>();
        int i = 0;
        while (i < this.fNumElements) {
            if (state[i + 1] == 0) {
                ret.addElement(this.fAllElements[i]);
            }
            ++i;
        }
        return ret;
    }

    Object findMatchingDecl(QName elementName, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        int i = 0;
        while (i < this.fNumElements) {
            matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i]);
            if (matchingDecl != null) break;
            ++i;
        }
        return matchingDecl;
    }

    public Object oneTransition(QName elementName, int[] currentState, SubstitutionGroupHandler subGroupHandler) {
        if (currentState[0] < 0) {
            currentState[0] = -2;
            return this.findMatchingDecl(elementName, subGroupHandler);
        }
        currentState[0] = 1;
        XSElementDecl matchingDecl = null;
        int i = 0;
        while (i < this.fNumElements) {
            if (currentState[i + 1] == 0 && (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i])) != null) {
                currentState[i + 1] = 1;
                return matchingDecl;
            }
            ++i;
        }
        currentState[0] = -1;
        return this.findMatchingDecl(elementName, subGroupHandler);
    }
}

