/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.AttrImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultDocument;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.TextImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    public void printDOM() {
    }

    public void reset() {
        if (this.relations != null) {
            int i = 0;
            while (i < this.relations.length) {
                int j = 0;
                while (j < this.relations[i].length) {
                    this.relations[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        int i = 0;
        while (i < 15) {
            this.relations[i] = new NodeImpl[10];
            ++i;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    private void resizeRelations() {
        NodeImpl[][] temp = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, temp, 0, this.relations.length);
        int i = this.relations.length;
        while (i < temp.length) {
            temp[i] = new NodeImpl[10];
            ++i;
        }
        this.relations = temp;
    }

    void startAnnotationCDATA() {
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    public static void indent(int amount) {
        int i = 0;
        while (i < amount) {
            System.out.print(' ');
            ++i;
        }
    }

    private void resizeRelations(int i) {
        NodeImpl[] temp = new NodeImpl[this.relations[i].length + 10];
        System.arraycopy(this.relations[i], 0, temp, 0, this.relations[i].length);
        this.relations[i] = temp;
    }

    void endAnnotationElement(QName elemName, boolean complete) {
        if (complete) {
            this.fAnnotationBuffer.append("\n</").append(elemName.rawname).append(">");
            ElementImpl child = (ElementImpl)this.relations[this.currLoc][1];
            if (this.nextFreeLoc == this.relations.length) {
                this.resizeRelations();
            }
            child.parentRow = this.nextFreeLoc++;
            int newRow = child.parentRow;
            boolean foundPlace = false;
            int i = 1;
            while (i < this.relations[newRow].length) {
                if (this.relations[newRow][i] == null) {
                    foundPlace = true;
                    break;
                }
                ++i;
            }
            if (!foundPlace) {
                this.resizeRelations(newRow);
            }
            this.relations[newRow][i] = new TextImpl(this.fAnnotationBuffer, this, newRow, i);
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(elemName.rawname).append(">");
        }
    }

    void characters(XMLString text) {
        int i = text.offset;
        while (i < text.offset + text.length) {
            if (text.ch[i] == '&') {
                this.fAnnotationBuffer.append("&amp;");
            } else if (text.ch[i] == '<') {
                this.fAnnotationBuffer.append("&lt;");
            } else {
                this.fAnnotationBuffer.append(text.ch[i]);
            }
            ++i;
        }
    }

    void comment(XMLString text) {
        this.fAnnotationBuffer.append("<!--").append(text.toString()).append("-->");
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    public static void traverse(Node node, int depth) {
        SchemaDOM.indent(depth);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                System.out.print("  " + ((Attr)attrs.item(i)).getName() + "=\"" + ((Attr)attrs.item(i)).getValue() + "\"");
                ++i;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            depth += 4;
            Node child = node.getFirstChild();
            while (child != null) {
                SchemaDOM.traverse(child, depth);
                child = child.getNextSibling();
            }
            SchemaDOM.indent(depth -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    void startAnnotationElement(QName elemName, XMLAttributes attributes) {
        this.fAnnotationBuffer.append("<").append(elemName.rawname).append(" ");
        int i = 0;
        while (i < attributes.getLength()) {
            String aValue = attributes.getValue(i);
            this.fAnnotationBuffer.append(" ").append(attributes.getQName(i)).append("=\"").append(SchemaDOM.processAttValue(aValue)).append("\" ");
            ++i;
        }
        this.fAnnotationBuffer.append(">");
    }

    public void emptyElement(QName element, XMLAttributes attributes, int line, int column) {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, node);
    }

    public void startElement(QName element, XMLAttributes attributes, int line, int column) {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, node);
        this.parent = node;
    }

    private static String processAttValue(String original) {
        StringBuffer newVal = new StringBuffer(original.length());
        int i = 0;
        while (i < original.length()) {
            char currChar = original.charAt(i);
            if (currChar == '\"') {
                newVal.append("&quot;");
            } else if (currChar == '>') {
                newVal.append("&gt;");
            } else if (currChar == '&') {
                newVal.append("&amp;");
            } else {
                newVal.append(currChar);
            }
            ++i;
        }
        return newVal.toString();
    }

    void processingInstruction(String target, String data) {
        this.fAnnotationBuffer.append("<?").append(target).append(" ").append(data).append("?>");
    }

    private void processElement(QName element, XMLAttributes attributes, ElementImpl node) {
        node.prefix = element.prefix;
        node.localpart = element.localpart;
        node.rawname = element.rawname;
        node.uri = element.uri;
        node.schemaDOM = this;
        Attr[] attrs = new Attr[attributes.getLength()];
        int i = 0;
        while (i < attributes.getLength()) {
            attrs[i] = new AttrImpl(null, attributes.getPrefix(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i));
            ++i;
        }
        node.attrs = attrs;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean foundPlace = false;
        int i2 = 1;
        i2 = 1;
        while (i2 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][i2] == null) {
                foundPlace = true;
                break;
            }
            ++i2;
        }
        if (!foundPlace) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][i2] = node;
        this.parent.parentRow = this.currLoc;
        node.row = this.currLoc;
        node.col = i2;
    }

    void startAnnotation(QName elemName, XMLAttributes attributes, NamespaceContext namespaceContext) {
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(elemName.rawname).append(" ");
        Vector<String> namespaces = new Vector<String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String aValue = attributes.getValue(i);
            String aPrefix = attributes.getPrefix(i);
            namespaces.addElement(aValue);
            this.fAnnotationBuffer.append(attributes.getQName(i)).append("=\"").append(aValue).append("\" ");
            ++i;
        }
        Enumeration currPrefixes = namespaceContext.getAllPrefixes();
        while (currPrefixes.hasMoreElements()) {
            String prefix = (String)currPrefixes.nextElement();
            String uri = namespaceContext.getURI(prefix);
            if (namespaces.contains(uri)) continue;
            if (prefix == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(uri).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(prefix).append("=\"").append(uri).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }
}

