/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.mail;

import africa.absa.inception.api.ApiUtil;
import africa.absa.inception.api.ProblemDetails;
import africa.absa.inception.api.SecureApi;
import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.mail.DuplicateMailTemplateException;
import africa.absa.inception.mail.IMailService;
import africa.absa.inception.mail.MailTemplate;
import africa.absa.inception.mail.MailTemplateNotFoundException;
import africa.absa.inception.mail.MailTemplateSummary;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Mail")
@RestController
@RequestMapping(value={"/api/mail"})
@CrossOrigin
public class MailApi
extends SecureApi {
    private static final Logger logger = LoggerFactory.getLogger(MailApi.class);
    private final IMailService mailService;

    public MailApi(ApplicationContext applicationContext, IMailService mailService) {
        super(applicationContext);
        this.mailService = mailService;
    }

    @Operation(summary="Create the mail template", description="Create the mail template")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="The mail template was created successfully"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="409", description="A mail template with the specified ID already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public void createMailTemplate(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="The mail template to create", required=true) @RequestBody MailTemplate mailTemplate) throws InvalidArgumentException, DuplicateMailTemplateException, ServiceUnavailableException {
        this.mailService.createMailTemplate(mailTemplate);
    }

    @Operation(summary="Delete the mail template", description="Delete the mail template")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="The mail template was deleted successfully"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="404", description="The mail template could not be found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates/{mailTemplateId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public void deleteMailTemplate(@Parameter(name="mailTemplateId", description="The ID for the mail template", required=true) @PathVariable String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        this.mailService.deleteMailTemplate(mailTemplateId);
    }

    @Operation(summary="Retrieve the mail template", description="Retrieve the mail template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="404", description="The mail template could not be found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates/{mailTemplateId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public MailTemplate getMailTemplate(@Parameter(name="mailTemplateId", description="The ID for the mail template", required=true) @PathVariable String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        return this.mailService.getMailTemplate(mailTemplateId);
    }

    @Operation(summary="Retrieve the name of the mail template", description="Retrieve the name of the mail template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="404", description="The mail template could not be found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates/{mailTemplateId}/name"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public String getMailTemplateName(@Parameter(name="mailTemplateId", description="The ID for the mail template", required=true) @PathVariable String mailTemplateId) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        return ApiUtil.quote((String)this.mailService.getMailTemplateName(mailTemplateId));
    }

    @Operation(summary="Retrieve the mail template summaries", description="Retrieve the mail template summaries")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-template-summaries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public List<MailTemplateSummary> getMailTemplateSummaries() throws ServiceUnavailableException {
        return this.mailService.getMailTemplateSummaries();
    }

    @Operation(summary="Retrieve the mail templates", description="Retrieve the mail templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public List<MailTemplate> getMailTemplates() throws ServiceUnavailableException {
        return this.mailService.getMailTemplates();
    }

    @Operation(summary="Update the mail template", description="Update the mail template")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="The mail template was updated successfully"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="404", description="The mail template could not be found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/mail-templates/{mailTemplateId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="isSecurityDisabled() or hasRole('Administrator') or hasAuthority('FUNCTION_Mail.MailTemplateAdministration')")
    public void updateMailTemplate(@Parameter(name="mailTemplateId", description="The ID for the mail template", required=true) @PathVariable String mailTemplateId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="The mail template to update", required=true) @RequestBody MailTemplate mailTemplate) throws InvalidArgumentException, MailTemplateNotFoundException, ServiceUnavailableException {
        if (!StringUtils.hasText((String)mailTemplateId)) {
            throw new InvalidArgumentException("mailTemplateId");
        }
        if (mailTemplate == null) {
            throw new InvalidArgumentException("mailTemplate");
        }
        if (!mailTemplateId.equals(mailTemplate.getId())) {
            throw new InvalidArgumentException("mailTemplate");
        }
        this.mailService.updateMailTemplate(mailTemplate);
    }
}

