/*
 * Decompiled with CFR 0.152.
 */
package africa.absa.inception.reference;

import africa.absa.inception.api.ProblemDetails;
import africa.absa.inception.api.SecureApi;
import africa.absa.inception.core.service.InvalidArgumentException;
import africa.absa.inception.core.service.ServiceUnavailableException;
import africa.absa.inception.reference.Country;
import africa.absa.inception.reference.IReferenceService;
import africa.absa.inception.reference.Language;
import africa.absa.inception.reference.MeasurementSystem;
import africa.absa.inception.reference.MeasurementUnit;
import africa.absa.inception.reference.MeasurementUnitType;
import africa.absa.inception.reference.Region;
import africa.absa.inception.reference.TimeZone;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Reference")
@RestController
@RequestMapping(value={"/api/reference"})
@CrossOrigin
public class ReferenceApi
extends SecureApi {
    private final IReferenceService referenceService;

    public ReferenceApi(ApplicationContext applicationContext, IReferenceService referenceService) {
        super(applicationContext);
        this.referenceService = referenceService;
    }

    @Operation(summary="Retrieve the country reference data for a specific locale", description="Retrieve the country reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/countries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<Country> getCountries(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the country reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getCountries(localeId);
    }

    @Operation(summary="Retrieve the language reference data for a specific locale", description="Retrieve the language reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/languages"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<Language> getLanguages(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the language reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getLanguages(localeId);
    }

    @Operation(summary="Retrieve the measurement system reference data for a specific locale", description="Retrieve the measurement system reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/measurement-systems"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<MeasurementSystem> getMeasurementSystems(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the measurement system reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getMeasurementSystems(localeId);
    }

    @Operation(summary="Retrieve the measurement unit type reference data for a specific locale", description="Retrieve the measurement unit type reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/measurement-unit-types"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<MeasurementUnitType> getMeasurementUnitTypes(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the measurement unit type reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getMeasurementUnitTypes(localeId);
    }

    @Operation(summary="Retrieve the measurement unit reference data for a specific locale", description="Retrieve the measurement unit reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/measurement-units"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<MeasurementUnit> getMeasurementUnits(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the measurement unit reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getMeasurementUnits(localeId);
    }

    @Operation(summary="Retrieve the region reference data for a specific locale", description="Retrieve the region reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/regions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<Region> getRegions(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the region reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getRegions(localeId);
    }

    @Operation(summary="Retrieve the time zone reference data for a specific locale", description="Retrieve the time zone reference data for a specific locale")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid argument", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))}), @ApiResponse(responseCode="500", description="An error has occurred and the request could not be processed at this time", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=ProblemDetails.class))})})
    @RequestMapping(value={"/time-zones"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isSecurityDisabled() or isAuthenticated()")
    public List<TimeZone> getTimeZones(@Parameter(name="localeId", description="The Unicode locale identifier for the locale to retrieve the time zone reference data for", example="en-US") @RequestParam(value="localeId", required=false, defaultValue="en-US") String localeId) throws InvalidArgumentException, ServiceUnavailableException {
        return this.referenceService.getTimeZones(localeId);
    }
}

