/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.StructField;
import ai.chronon.api.StructType;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Extensions$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareMetrics$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CompareBaseJob$ {
    public static CompareBaseJob$ MODULE$;

    static {
        new CompareBaseJob$();
    }

    public void checkConsistency(Map<String, DataType> leftFields, Map<String, DataType> rightFields, Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        ListBuffer errors = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean sizeCheck = migrationCheck ? leftFields.size() >= rightFields.size() : leftFields.size() == rightFields.size();
        Object object = !sizeCheck ? errors.$plus$eq((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("Inconsistent number of fields; left side: ").append(leftFields.size()).append(", right side: ").append(rightFields.size()).append("\n                |Left side fields:\n                | - ").append(((TraversableOnce)leftFields.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).mkString("\n - ")).append("\n                |\n                |Right side fields:\n                | - ").append(((TraversableOnce)rightFields.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).mkString("\n - ")).append("\n                |").toString())).stripMargin()) : BoxedUnit.UNIT;
        Map reverseMapping = (Map)mapping.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.swap(), Map$.MODULE$.canBuildFrom());
        rightFields.foreach((Function1 & Serializable & scala.Serializable)rightField -> {
            Object object;
            String leftFieldName;
            String string = leftFieldName = reverseMapping.contains(rightField._1()) ? (String)reverseMapping.get(rightField._1()).get() : (String)rightField._1();
            if (leftFields.contains((Object)leftFieldName)) {
                DataType leftFieldType = (DataType)leftFields.get((Object)leftFieldName).get();
                Object object2 = rightField._2();
                DataType dataType = leftFieldType;
                object = (object2 == null ? dataType != null : !object2.equals(dataType)) ? errors.$plus$eq((Object)new StringBuilder(75).append("Comparison data types do not match for column '").append(leftFieldName).append("';").append(" left side: ").append(leftFieldType).append(", right side: ").append(rightField._2()).toString()) : BoxedUnit.UNIT;
            } else {
                object = errors.$plus$eq((Object)new StringBuilder(62).append("Mapping column on the left table is not present; column name: ").append(leftFieldName).toString());
            }
            return object;
        });
        Object object2 = mapping.size() != reverseMapping.size() ? errors.$plus$eq((Object)new StringBuilder(57).append("Mapping values contain duplicate values. Keys: ").append(mapping.keys()).append(", Values: ").append(mapping.values()).toString()) : BoxedUnit.UNIT;
        Object object3 = !mapping.keySet().subsetOf((GenSet)leftFields.keySet()) ? errors.$plus$eq((Object)new StringBuilder(79).append("Invalid mapping provided missing fields; provided: ").append(mapping.keySet()).append(",").append(" expected to be subset of: ").append(leftFields.keySet()).toString()) : BoxedUnit.UNIT;
        Object object4 = !mapping.values().toSet().subsetOf((GenSet)rightFields.keySet()) ? errors.$plus$eq((Object)new StringBuilder(79).append("Invalid mapping provided missing fields; provided: ").append(mapping.values().toSet()).append(",").append(" expected to be subset of: ").append(rightFields.keySet()).toString()) : BoxedUnit.UNIT;
        ((IterableLike)new .colon.colon(leftFields, (List)new .colon.colon(rightFields, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)kset -> !keys.toSet().subsetOf((GenSet)kset.keySet()) ? errors.$plus$eq((Object)new StringBuilder(100).append("Some of the primary keys are missing in the source dataframe; provided: ").append(keys).append(",").append(" expected to be subset of: ").append(kset.keySet()).toString()) : BoxedUnit.UNIT);
        Object object5 = ((SeqLike)keys.intersect((GenSeq)Constants$.MODULE$.ReservedColumns(tableUtils.partitionColumn()))).length() == 0 ? errors.$plus$eq((Object)"Ensure that one of the key columns is a time column") : BoxedUnit.UNIT;
        Predef$.MODULE$.assert(errors.size() == 0, (Function0 & Serializable & scala.Serializable)() -> errors.mkString("\n-----------------------------------------------------------------\n"));
    }

    public Map<String, String> checkConsistency$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean checkConsistency$default$6() {
        return false;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> compare(Dataset<Row> leftDf, Dataset<Row> rightDf, Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        Map leftFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map rightFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.checkConsistency((Map<String, DataType>)leftFields, (Map<String, DataType>)rightFields, keys, tableUtils, mapping, migrationCheck);
        ListBuffer prunedColumns = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Dataset prunedLeftDf = migrationCheck ? (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fieldNames())).foldLeft(leftDf, (Function2 & Serializable & scala.Serializable)(df, field) -> {
            Dataset dataset;
            String rightFieldName;
            String string = rightFieldName = mapping.contains(field) ? (String)mapping.get(field).get() : field;
            if (!rightFields.contains((Object)rightFieldName)) {
                prunedColumns.$plus$eq(field);
                dataset = df.drop(field);
            } else {
                dataset = df;
            }
            return dataset;
        }) : leftDf;
        Predef$.MODULE$.println((Object)new StringBuilder(64).append("Pruning fields from the left source for equivalent comparison - ").append(prunedColumns.mkString(",")).toString());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Join keys: ").append(keys.mkString(", ")).append("\n        |Left Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(prunedLeftDf.schema()).pretty()).append("\n        |\n        |Right Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(rightDf.schema()).pretty()).append("\n        |\n        |").toString())).stripMargin());
        Dataset renamedLeftDf = (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prunedLeftDf.schema().fieldNames())).foldLeft((Object)prunedLeftDf, (Function2 & Serializable & scala.Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.leftSuffix()).toString()) : df);
        Extensions$.MODULE$.DataframeOps((Dataset<Row>)renamedLeftDf).validateJoinKeys(rightDf, keys);
        Dataset joinedDf = renamedLeftDf.join(rightDf, keys, "full");
        Dataset compareDf = (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fieldNames())).foldLeft((Object)joinedDf, (Function2 & Serializable & scala.Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.rightSuffix()).toString()) : df);
        StructType leftChrononSchema = new StructType("input", (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkConversions$.MODULE$.toChrononSchema(prunedLeftDf.schema()))).filterNot((Function1 & Serializable & scala.Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)keys.contains(tup._1()))))).map((Function1 & Serializable & scala.Serializable)tup -> new StructField((String)tup._1(), (ai.chronon.api.DataType)tup._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Tuple2<Dataset<Row>, DataMetrics> tuple2 = CompareMetrics$.MODULE$.compute(leftChrononSchema.fields(), (Dataset<Row>)compareDf, keys, mapping, CompareMetrics$.MODULE$.compute$default$5());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset metricsDf = (Dataset)tuple2._1();
        DataMetrics metrics = (DataMetrics)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricsDf, (Object)metrics);
        Tuple2 tuple23 = tuple22;
        Dataset metricsDf2 = (Dataset)tuple23._1();
        DataMetrics metrics2 = (DataMetrics)tuple23._2();
        return new Tuple3((Object)compareDf, (Object)metricsDf2, (Object)metrics2);
    }

    public Map<String, String> compare$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean compare$default$6() {
        return false;
    }

    private CompareBaseJob$() {
        MODULE$ = this;
    }
}

