/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.online.KVStore;
import com.yahoo.sketches.kll.KllFloatsSketch;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\te\u0001\u0011\t\u0011)A\u0005_!)1\u0007\u0001C\u0001i!A\u0001\b\u0001EC\u0002\u0013\u0005\u0011\bC\u0004G\u0001\u0001\u0007I\u0011B$\t\u000fQ\u0003\u0001\u0019!C\u0005+\"11\f\u0001Q!\n!Cq\u0001\u0018\u0001A\u0002\u0013%Q\fC\u0004b\u0001\u0001\u0007I\u0011\u00022\t\r\u0011\u0004\u0001\u0015)\u0003_\u0011\u001d)\u0007\u00011A\u0005\nuCqA\u001a\u0001A\u0002\u0013%q\r\u0003\u0004j\u0001\u0001\u0006KA\u0018\u0005\bU\u0002\u0001\r\u0011\"\u0003^\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001c\u0001!B\u0013q\u0006bB8\u0001\u0001\u0004%I!\u0018\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u0011\u0019\u0019\b\u0001)Q\u0005=\"9A\u000f\u0001a\u0001\n\u0013i\u0006bB;\u0001\u0001\u0004%IA\u001e\u0005\u0007q\u0002\u0001\u000b\u0015\u00020\t\u000fe\u0004!\u0019!C\u0005u\"9\u00111\u0002\u0001!\u0002\u0013Y\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\u0011ab\u0015;sK\u0006l\u0017N\\4Ti\u0006$8O\u0003\u0002\u001f?\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\u000f\rD'o\u001c8p]*\tA%\u0001\u0002bS\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006\u0019\u0002/\u001e2mSNDG)\u001a7bsN+7m\u001c8egV\tq\u0006\u0005\u0002)a%\u0011\u0011'\u000b\u0002\u0004\u0013:$\u0018\u0001\u00069vE2L7\u000f\u001b#fY\u0006L8+Z2p]\u0012\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003uAQ!L\u0002A\u0002=\na\u0001\\8hO\u0016\u0014X#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!B:mMRR'\"A \u0002\u0007=\u0014x-\u0003\u0002By\t1Aj\\4hKJD#\u0001B\"\u0011\u0005!\"\u0015BA#*\u0005%!(/\u00198tS\u0016tG/\u0001\tmCR,gnY=ISN$xn\u001a:b[V\t\u0001\n\u0005\u0002J%6\t!J\u0003\u0002L\u0019\u0006\u00191\u000e\u001c7\u000b\u00055s\u0015\u0001C:lKR\u001c\u0007.Z:\u000b\u0005=\u0003\u0016!B=bQ>|'\"A)\u0002\u0007\r|W.\u0003\u0002T\u0015\ny1\n\u001c7GY>\fGo]*lKR\u001c\u0007.\u0001\u000bmCR,gnY=ISN$xn\u001a:b[~#S-\u001d\u000b\u0003-f\u0003\"\u0001K,\n\u0005aK#\u0001B+oSRDqA\u0017\u0004\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\n\u0011\u0003\\1uK:\u001c\u0017\u0010S5ti><'/Y7!\u00039a\u0017\r^3oGfl5\u000fV8uC2,\u0012A\u0018\t\u0003Q}K!\u0001Y\u0015\u0003\t1{gnZ\u0001\u0013Y\u0006$XM\\2z\u001bN$v\u000e^1m?\u0012*\u0017\u000f\u0006\u0002WG\"9!,CA\u0001\u0002\u0004q\u0016a\u00047bi\u0016t7-_'t)>$\u0018\r\u001c\u0011\u0002\u0017]\u0014\u0018\u000e^3t)>$\u0018\r\\\u0001\u0010oJLG/Z:U_R\fGn\u0018\u0013fcR\u0011a\u000b\u001b\u0005\b52\t\t\u00111\u0001_\u000319(/\u001b;fgR{G/\u00197!\u00035YW-\u001f\"zi\u0016\u001cHk\u001c;bY\u0006\t2.Z=CsR,7\u000fV8uC2|F%Z9\u0015\u0005Yk\u0007b\u0002.\u0010\u0003\u0003\u0005\rAX\u0001\u000fW\u0016L()\u001f;fgR{G/\u00197!\u0003=1\u0018\r\\;f\u0005f$Xm\u001d+pi\u0006d\u0017a\u0005<bYV,')\u001f;fgR{G/\u00197`I\u0015\fHC\u0001,s\u0011\u001dQ&#!AA\u0002y\u000b\u0001C^1mk\u0016\u0014\u0015\u0010^3t)>$\u0018\r\u001c\u0011\u0002\u000fM$\u0018M\u001d;Ng\u0006Y1\u000f^1si6\u001bx\fJ3r)\t1v\u000fC\u0004[+\u0005\u0005\t\u0019\u00010\u0002\u0011M$\u0018M\u001d;Ng\u0002\n1!\u001e;d+\u0005Y\bc\u0001?\u0002\b5\tQP\u0003\u0002\u007f\u007f\u00061am\u001c:nCRTA!!\u0001\u0002\u0004\u0005!A/[7f\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005{\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\u0002\tU$8\rI\u0001\u000bi&lWm\u0015;sS:<GCBA\t\u0003;\t\t\u0003\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\u0011\t9\"a\u0001\u0002\t1\fgnZ\u0005\u0005\u00037\t)B\u0001\u0004TiJLgn\u001a\u0005\u0007\u0003?I\u0002\u0019A>\u0002\u0013\u0019|'/\\1ui\u0016\u0014\bBBA\u00123\u0001\u0007a,\u0001\u0002ug\u0006Y\u0001O]5oiN#\u0018\r^;t)\u00051\u0016!C5oGJ,W.\u001a8u)\r1\u0016Q\u0006\u0005\b\u0003_Y\u0002\u0019AA\u0019\u0003)\u0001X\u000f\u001e*fcV,7\u000f\u001e\t\u0005\u0003g\tyE\u0004\u0003\u00026\u0005%c\u0002BA\u001c\u0003\u000brA!!\u000f\u0002D9!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0015\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013bAA$C\u00051qN\u001c7j]\u0016LA!a\u0013\u0002N\u000591JV*u_J,'bAA$C%!\u0011\u0011KA*\u0005)\u0001V\u000f\u001e*fcV,7\u000f\u001e\u0006\u0005\u0003\u0017\ni\u0005")
public class StreamingStats {
    private transient Logger logger;
    private final int publishDelaySeconds;
    private KllFloatsSketch latencyHistogram;
    private long latencyMsTotal;
    private long writesTotal;
    private long keyBytesTotal;
    private long valueBytesTotal;
    private long startMs;
    private final DateTimeFormatter utc;
    private volatile transient boolean bitmap$trans$0;

    public int publishDelaySeconds() {
        return this.publishDelaySeconds;
    }

    private Logger logger$lzycompute() {
        StreamingStats streamingStats = this;
        synchronized (streamingStats) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private KllFloatsSketch latencyHistogram() {
        return this.latencyHistogram;
    }

    private void latencyHistogram_$eq(KllFloatsSketch x$1) {
        this.latencyHistogram = x$1;
    }

    private long latencyMsTotal() {
        return this.latencyMsTotal;
    }

    private void latencyMsTotal_$eq(long x$1) {
        this.latencyMsTotal = x$1;
    }

    private long writesTotal() {
        return this.writesTotal;
    }

    private void writesTotal_$eq(long x$1) {
        this.writesTotal = x$1;
    }

    private long keyBytesTotal() {
        return this.keyBytesTotal;
    }

    private void keyBytesTotal_$eq(long x$1) {
        this.keyBytesTotal = x$1;
    }

    private long valueBytesTotal() {
        return this.valueBytesTotal;
    }

    private void valueBytesTotal_$eq(long x$1) {
        this.valueBytesTotal = x$1;
    }

    private long startMs() {
        return this.startMs;
    }

    private void startMs_$eq(long x$1) {
        this.startMs = x$1;
    }

    private DateTimeFormatter utc() {
        return this.utc;
    }

    private String timeString(DateTimeFormatter formatter, long ts) {
        return formatter.format(Instant.ofEpochMilli(ts));
    }

    public void printStatus() {
        if (this.writesTotal() > 0L) {
            long now = System.currentTimeMillis();
            String threadName = new StringBuilder(7).append("Thread-").append(Thread.currentThread().getId()).toString();
            float medianLatency = this.latencyHistogram().getQuantile(0.5);
            float p95Latency = this.latencyHistogram().getQuantile(0.95);
            float p99Latency = this.latencyHistogram().getQuantile(0.99);
            this.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("\n         |[").append(threadName).append("][").append(this.timeString(this.utc(), now)).append("] Wrote ").append(this.writesTotal()).append(" records in last ").append(now - this.startMs()).append(" ms.         \n         | Latency ms: ").append(this.latencyMsTotal() / this.writesTotal()).append(" (avg) / ").append(medianLatency).append(" (median) / ").append(p95Latency).append(" (p95) / ").append(p99Latency).append(" (p99) \n         |   Key Size: ").append(this.keyBytesTotal() / this.writesTotal()).append(" bytes (avg) / ").append(StreamingStats.readable$1().apply((Object)BoxesRunTime.boxToLong((long)this.keyBytesTotal()))).append(" (total)\n         | Value Size: ").append(this.valueBytesTotal() / this.writesTotal()).append(" bytes (avg) / ").append(StreamingStats.readable$1().apply((Object)BoxesRunTime.boxToLong((long)this.valueBytesTotal()))).append(" (total)\n         |").toString())).stripMargin());
            this.latencyMsTotal_$eq(0L);
            this.writesTotal_$eq(0L);
            this.keyBytesTotal_$eq(0L);
            this.valueBytesTotal_$eq(0L);
            this.latencyHistogram_$eq(new KllFloatsSketch());
            this.startMs_$eq(now);
        } else {
            this.logger().info("No writes registered");
        }
    }

    public void increment(KVStore.PutRequest putRequest) {
        block2: {
            putRequest.tsMillis().foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)queryTime -> {
                long latency = System.currentTimeMillis() - queryTime;
                this.latencyMsTotal_$eq(this.latencyMsTotal() + latency);
                this.latencyHistogram().update((float)latency);
            });
            this.writesTotal_$eq(this.writesTotal() + 1L);
            if (putRequest.keyBytes() != null) {
                this.keyBytesTotal_$eq(this.keyBytesTotal() + (long)putRequest.keyBytes().length);
            }
            if (putRequest.valueBytes() != null) {
                this.valueBytesTotal_$eq(this.valueBytesTotal() + (long)putRequest.valueBytes().length);
            }
            if (System.currentTimeMillis() - this.startMs() <= (long)this.publishDelaySeconds() * 1000L) break block2;
            this.printStatus();
        }
    }

    public static final /* synthetic */ String $anonfun$printStatus$1(long x) {
        return FileUtils.byteCountToDisplaySize((long)x);
    }

    private static final Function1 readable$1() {
        return (Function1 & java.io.Serializable & Serializable)x -> StreamingStats.$anonfun$printStatus$1(BoxesRunTime.unboxToLong((Object)x));
    }

    public StreamingStats(int publishDelaySeconds) {
        this.publishDelaySeconds = publishDelaySeconds;
        this.latencyHistogram = new KllFloatsSketch();
        this.latencyMsTotal = 0L;
        this.writesTotal = 0L;
        this.keyBytesTotal = 0L;
        this.valueBytesTotal = 0L;
        this.startMs = System.currentTimeMillis();
        this.utc = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    }
}

