/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.spark;

import ai.databand.DbndWrapper;
import ai.databand.spark.SparkIOSource;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import scala.Tuple2;
import scala.collection.Iterator;

public class DbndSparkListener
extends SparkListener {
    private final DbndWrapper dbnd;

    public DbndSparkListener(DbndWrapper dbnd) {
        this.dbnd = dbnd;
    }

    public DbndSparkListener() {
        this.dbnd = DbndWrapper.instance();
    }

    public void onOtherEvent(SparkListenerEvent event) {
        if (event instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)event;
        }
    }

    protected void extractIoInfo(SparkPlanInfo plan) {
        for (Tuple2 next : plan.metadata()) {
            if (!"Location".equalsIgnoreCase((String)next._1())) continue;
            SparkIOSource source = new SparkIOSource((String)next._2(), "spark_plan_info");
            this.dbnd.logMetric(source.metricKey(), source);
        }
        Iterator it = plan.children().iterator();
        while (it.hasNext()) {
            this.extractIoInfo((SparkPlanInfo)it.next());
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        try {
            this.dbnd.logSpark((SparkListenerEvent)stageCompleted);
        }
        catch (Throwable e) {
            System.out.println("DbndSparkListener: Unable to log spark metrics");
            e.printStackTrace();
        }
    }
}

