/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.BaseModel;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.onnxruntime.engine.OrtSymbolBlock;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public class OrtModel
extends BaseModel {
    private OrtEnvironment env;

    OrtModel(String name, NDManager manager, OrtEnvironment env) {
        super(name);
        this.manager = manager;
        this.manager.setName("ortModel");
        this.env = env;
        this.dataType = DataType.FLOAT32;
    }

    public void load(Path modelPath, String prefix, Map<String, ?> options) throws IOException, MalformedModelException {
        this.modelDir = modelPath.toAbsolutePath();
        if (this.block != null) {
            throw new UnsupportedOperationException("ONNX Runtime does not support dynamic blocks");
        }
        Path modelFile = this.findModelFile(prefix);
        if (modelFile == null && (modelFile = this.findModelFile(this.modelDir.toFile().getName())) == null) {
            throw new FileNotFoundException(".onnx file not found in: " + modelPath);
        }
        try {
            Device device = this.manager.getDevice();
            if ("gpu".equals(device.getDeviceType())) {
                OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
                sessionOptions.addCUDA(this.manager.getDevice().getDeviceId());
                this.block = new OrtSymbolBlock(this.env.createSession(modelFile.toString(), sessionOptions));
            } else {
                this.block = new OrtSymbolBlock(this.env.createSession(modelFile.toString()));
            }
        }
        catch (OrtException e) {
            throw new MalformedModelException("ONNX Model cannot be loaded", (Throwable)e);
        }
    }

    private Path findModelFile(String prefix) {
        Path modelFile;
        if (Files.isRegularFile(this.modelDir, new LinkOption[0])) {
            Path file = this.modelDir;
            this.modelDir = this.modelDir.getParent();
            String fileName = file.toFile().getName();
            this.modelName = fileName.endsWith(".onnx") ? fileName.substring(0, fileName.length() - 5) : fileName;
            return file;
        }
        if (prefix == null) {
            prefix = this.modelName;
        }
        if (Files.notExists(modelFile = this.modelDir.resolve(prefix), new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
            if (prefix.endsWith(".onnx")) {
                return null;
            }
            modelFile = this.modelDir.resolve(prefix + ".onnx");
            if (Files.notExists(modelFile, new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
                return null;
            }
        }
        return modelFile;
    }

    public void close() {
        ((OrtSymbolBlock)this.block).close();
        super.close();
    }
}

