/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.util.ArrayList;
import java.util.Iterator;
import ml.dmlc.xgboost4j.LabeledPoint;

class DataBatch {
    long[] rowOffset = null;
    float[] weight = null;
    float[] label = null;
    int[] featureIndex = null;
    float[] featureValue = null;

    public DataBatch() {
    }

    public DataBatch(long[] rowOffset, float[] weight, float[] label, int[] featureIndex, float[] featureValue) {
        this.rowOffset = rowOffset;
        this.weight = weight;
        this.label = label;
        this.featureIndex = featureIndex;
        this.featureValue = featureValue;
    }

    public int numRows() {
        return this.rowOffset.length - 1;
    }

    public DataBatch shallowCopy() {
        DataBatch b = new DataBatch();
        b.rowOffset = this.rowOffset;
        b.weight = this.weight;
        b.label = this.label;
        b.featureIndex = this.featureIndex;
        b.featureValue = this.featureValue;
        return b;
    }

    static class BatchIterator
    implements Iterator<DataBatch> {
        private Iterator<LabeledPoint> base;
        private int batchSize;

        BatchIterator(Iterator<LabeledPoint> base, int batchSize) {
            this.base = base;
            this.batchSize = batchSize;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public DataBatch next() {
            int num_rows = 0;
            int num_elem = 0;
            ArrayList<LabeledPoint> batch = new ArrayList<LabeledPoint>();
            for (int i = 0; i < this.batchSize && this.base.hasNext(); ++i) {
                LabeledPoint inst = this.base.next();
                batch.add(inst);
                num_elem += inst.values.length;
                ++num_rows;
            }
            DataBatch ret = new DataBatch();
            ret.rowOffset = new long[num_rows + 1];
            ret.label = new float[num_rows];
            ret.featureIndex = new int[num_elem];
            ret.featureValue = new float[num_elem];
            int offset = 0;
            for (int i = 0; i < batch.size(); ++i) {
                LabeledPoint inst = (LabeledPoint)batch.get(i);
                ret.rowOffset[i] = offset;
                ret.label[i] = inst.label;
                if (inst.indices != null) {
                    System.arraycopy(inst.indices, 0, ret.featureIndex, offset, inst.indices.length);
                } else {
                    for (int j = 0; j < inst.values.length; ++j) {
                        ret.featureIndex[offset + j] = j;
                    }
                }
                System.arraycopy(inst.values, 0, ret.featureValue, offset, inst.values.length);
                offset += inst.values.length;
            }
            ret.rowOffset[batch.size()] = offset;
            return ret;
        }

        @Override
        public void remove() {
            throw new Error("not implemented");
        }
    }
}

