/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.InMemoryMojoReaderBackend;
import java.io.BufferedReader;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryMojoReaderBackendTest {
    private InMemoryMojoReaderBackend readerBackend;

    @Before
    public void setup() {
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        content.put("text-file", "line1\nline2\n".getBytes());
        content.put("binary-file", new byte[]{0, 1, 2});
        this.readerBackend = new InMemoryMojoReaderBackend(content);
    }

    @Test
    public void testGetTextFile() throws Exception {
        try (BufferedReader r = this.readerBackend.getTextFile("text-file");){
            Assert.assertEquals((Object)"line1", (Object)r.readLine());
            Assert.assertEquals((Object)"line2", (Object)r.readLine());
            Assert.assertNull((Object)r.readLine());
        }
    }

    @Test
    public void testGetBinaryFile() throws Exception {
        byte[] data = this.readerBackend.getBinaryFile("binary-file");
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2}, (byte[])data);
    }

    @Test
    public void testExists() throws Exception {
        Assert.assertFalse((boolean)this.readerBackend.exists("invalid-file"));
        Assert.assertTrue((boolean)this.readerBackend.exists("text-file"));
    }

    @Test
    public void testClose() throws Exception {
        this.readerBackend.close();
        try {
            this.readerBackend.exists(null);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"ReaderBackend was already closed", (Object)e.getMessage());
        }
    }
}

