/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.GenModel;
import hex.genmodel.InMemoryMojoReaderBackend;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.TmpMojoReaderBackend;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class MojoReaderBackendFactoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateReaderBackend_URL_Memory() throws Exception {
        URL dumjo = MojoReaderBackendFactoryTest.class.getResource("dumjo.zip");
        Assert.assertNotNull((Object)dumjo);
        Assert.assertTrue((boolean)(r instanceof InMemoryMojoReaderBackend));
        try (MojoReaderBackend r = MojoReaderBackendFactory.createReaderBackend((URL)dumjo, (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);){
            Assert.assertTrue((boolean)r.exists("binary-file"));
            Assert.assertTrue((boolean)r.exists("text-file"));
            Assert.assertEquals((Object)"line1", (Object)r.getTextFile("text-file").readLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateReaderBackend_URL_Disk() throws Exception {
        URL dumjo = MojoReaderBackendFactoryTest.class.getResource("dumjo.zip");
        Assert.assertNotNull((Object)dumjo);
        MojoReaderBackend r = MojoReaderBackendFactory.createReaderBackend((URL)dumjo, (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.DISK);
        Assert.assertTrue((boolean)(r instanceof TmpMojoReaderBackend));
        File tempFile = ((TmpMojoReaderBackend)r)._tempZipFile;
        Assert.assertTrue((boolean)tempFile.exists());
        try {
            Assert.assertTrue((boolean)r.exists("binary-file"));
            Assert.assertTrue((boolean)r.exists("text-file"));
            Assert.assertEquals((Object)"line1", (Object)r.getTextFile("text-file").readLine());
        }
        finally {
            ((Closeable)r).close();
        }
        Assert.assertFalse((boolean)tempFile.exists());
    }

    @Test
    public void testMojoE2E_Memory() throws Exception {
        this.testMojoE2E(MojoReaderBackendFactory.CachingStrategy.MEMORY);
    }

    @Test
    public void testMojoE2E_Disk() throws Exception {
        this.testMojoE2E(MojoReaderBackendFactory.CachingStrategy.DISK);
    }

    private void testMojoE2E(MojoReaderBackendFactory.CachingStrategy cachingStrategy) throws Exception {
        URL mojoSource = MojoReaderBackendFactoryTest.class.getResource("mojo.zip");
        Assert.assertNotNull((Object)mojoSource);
        MojoReaderBackend reader = MojoReaderBackendFactory.createReaderBackend((URL)mojoSource, (MojoReaderBackendFactory.CachingStrategy)cachingStrategy);
        MojoModel model = ModelMojoReader.readFrom((MojoReaderBackend)reader);
        EasyPredictModelWrapper modelWrapper = new EasyPredictModelWrapper((GenModel)model);
        RowData testRow = MojoReaderBackendFactoryTest.makeTestRow();
        RegressionModelPrediction prediction = (RegressionModelPrediction)modelWrapper.predict(testRow);
        Assert.assertEquals((double)71.085, (double)prediction.value, (double)0.001);
    }

    private static RowData makeTestRow() {
        RowData testRow = new RowData();
        String[] row = "75,0,190,80,91,193,371,174,121,-16,13,64,-2,0,63,0,52,44,0,0,32,0,0,0,0,0,0,0,44,20,36,0,28,0,0,0,0,0,0,52,40,0,0,0,60,0,0,0,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,56,36,0,0,32,0,0,0,0,0,0,48,32,0,0,0,56,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,40,52,0,0,28,0,0,0,0,0,0,0,48,48,0,0,32,0,0,0,0,0,0,0,52,52,0,0,36,0,0,0,0,0,0,0,52,48,0,0,32,0,0,0,0,0,0,0,56,44,0,0,32,0,0,0,0,0,0,-0.2,0.0,6.1,-1.0,0.0,0.0,0.6,2.1,13.6,30.8,0.0,0.0,1.7,-1.0,0.6,0.0,1.3,1.5,3.7,14.5,0.1,-5.2,1.4,0.0,0.0,0.0,0.8,-0.6,-10.7,-15.6,0.4,-3.9,0.0,0.0,0.0,0.0,-0.8,-1.7,-10.1,-22.0,0.0,0.0,5.7,-1.0,0.0,0.0,-0.1,1.2,14.1,22.5,0.0,-2.5,0.8,0.0,0.0,0.0,1.0,0.4,-4.8,-2.7,0.1,-6.0,0.0,0.0,0.0,0.0,-0.8,-0.6,-24.0,-29.7,0.0,0.0,2.0,-6.4,0.0,0.0,0.2,2.9,-12.6,15.2,-0.1,0.0,8.4,-10.0,0.0,0.0,0.6,5.9,-3.9,52.7,-0.3,0.0,15.2,-8.4,0.0,0.0,0.9,5.1,17.7,70.7,-0.4,0.0,13.5,-4.0,0.0,0.0,0.9,3.9,25.5,62.9,-0.3,0.0,9.0,-0.9,0.0,0.0,0.9,2.9,23.3,49.4,8".split(",");
        for (int i = 0; i < row.length; ++i) {
            testRow.put((Object)("C" + (i + 1)), (Object)Double.valueOf(row[i]));
        }
        return testRow;
    }
}

