/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gbm;

import com.google.common.io.ByteStreams;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;

public class GbmMojoModelTest {
    @Test
    public void testPredict() throws Exception {
        GbmMojoModel mojo = (GbmMojoModel)ModelMojoReader.readFrom((MojoReaderBackend)new ClasspathReaderBackend());
        Assert.assertNotNull((Object)mojo);
        EasyPredictModelWrapper wrapper = new EasyPredictModelWrapper((GenModel)mojo);
        BinomialModelPrediction pred = (BinomialModelPrediction)wrapper.predict(new RowData(){
            {
                this.put("SegSumT", 18.7);
                this.put("SegTSeas", 1.51);
                this.put("SegLowFlow", 1.003);
                this.put("DSDist", 132.53);
                this.put("DSMaxSlope", 1.15);
                this.put("USAvgT", 0.2);
                this.put("USRainDays", 1.153);
                this.put("USSlope", 8.3);
                this.put("USNative", 0.34);
                this.put("DSDam", 0.0);
                this.put("Method", "electric");
            }
        });
        Assert.assertEquals((long)1L, (long)pred.labelIndex);
        Assert.assertEquals((Object)"1", (Object)pred.label);
        Assert.assertArrayEquals((double[])new double[]{0.5416688, 0.4583312}, (double[])pred.classProbabilities, (double)1.0E-5);
        Assert.assertArrayEquals((double[])new double[]{0.3920402, 0.6079598}, (double[])pred.calibratedClassProbabilities, (double)1.0E-5);
    }

    private static class ClasspathReaderBackend
    implements MojoReaderBackend {
        private ClasspathReaderBackend() {
        }

        public BufferedReader getTextFile(String filename) throws IOException {
            InputStream is = GbmMojoModelTest.class.getResourceAsStream("calibrated/" + filename);
            return new BufferedReader(new InputStreamReader(is));
        }

        public byte[] getBinaryFile(String filename) throws IOException {
            InputStream is = GbmMojoModelTest.class.getResourceAsStream("calibrated/" + filename);
            return ByteStreams.toByteArray((InputStream)is);
        }

        public boolean exists(String name) {
            return true;
        }
    }
}

