/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.glm.GlmMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;

public class GlmMojoModelTest {
    @Test
    public void testScore0() throws Exception {
        double[][] data = new double[][]{{2.0, 73.0, 2.0, 1.0, 7.9, 18.0, 6.0}, {1.0, 51.0, 3.0, 1.0, 8.9, 0.0, 6.0}, {2.0, 57.0, 3.0, 1.0, 3.4, 30.8, 6.0}, {1.0, 65.0, 4.0, 1.0, 6.3, 0.0, 6.0}, {1.0, 61.0, 3.0, 1.0, 1.5, 0.0, 5.0}, {1.0, 56.0, 2.0, 2.0, 58.0, 0.0, 6.0}, {1.0, 72.0, 2.0, 1.0, 1.4, 24.2, 6.0}, {1.0, 54.0, 2.0, 1.0, 18.0, 43.0, 9.0}, {1.0, 62.0, 2.0, 1.0, 7.3, 0.0, 7.0}, {2.0, 63.0, 3.0, 1.0, 14.3, 16.0, 7.0}, {1.0, 68.0, 1.0, 1.0, 5.4, 34.0, 5.0}, {1.0, Double.NaN, 1.0, 1.0, 5.4, 34.0, 5.0}};
        double[][] expPreds = new double[][]{{0.0, 0.883740206424754, 0.11625979357524593}, {1.0, 0.5591006829867439, 0.44089931701325613}, {0.0, 0.8200793110208472, 0.1799206889791528}, {1.0, 0.4855023555733662, 0.5144976444266338}, {0.0, 0.8260781970262484, 0.17392180297375157}, {1.0, 0.2685796973779421, 0.7314203026220579}, {0.0, 0.8265057623033865, 0.1734942376966135}, {1.0, 0.1332488800455477, 0.8667511199544523}, {1.0, 0.5038183003787983, 0.49618169962120173}, {1.0, 0.5384202639029669, 0.46157973609703307}, {0.0, 0.9543248143434919, 0.04567518565650803}, {0.0, 0.9531416700165544, 0.046858329983445586}};
        GlmMojoModel mojo = (GlmMojoModel)ModelMojoReader.readFrom((MojoReaderBackend)new ClasspathReaderBackend());
        for (int i = 0; i < data.length; ++i) {
            double[] preds = mojo.score0(data[i], new double[3]);
            Assert.assertArrayEquals((String)("Predictions for row #" + i), (double[])expPreds[i], (double[])preds, (double)1.0E-7);
        }
    }

    private static class ClasspathReaderBackend
    implements MojoReaderBackend {
        private ClasspathReaderBackend() {
        }

        public BufferedReader getTextFile(String filename) throws IOException {
            InputStream is = GlmMojoModelTest.class.getResourceAsStream("prostate/" + filename);
            return new BufferedReader(new InputStreamReader(is));
        }

        public byte[] getBinaryFile(String filename) throws IOException {
            throw new UnsupportedOperationException("Unexpected call to getBinaryFile()");
        }

        public boolean exists(String name) {
            throw new UnsupportedOperationException("Unexpected call to exists()");
        }
    }
}

