/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.glm.GlmMojoModel;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import hex.genmodel.algos.glm.GlmMojoReader;
import hex.genmodel.algos.glm.GlmMultinomialMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;

public class GlmMojoReaderTest {
    @Test
    public void readModelData() throws Exception {
        GlmMojoModel model = (GlmMojoModel)ModelMojoReader.readFrom((MojoReaderBackend)new MojoReaderBackend(){

            public BufferedReader getTextFile(String filename) throws IOException {
                if ("model.ini".equals(filename)) {
                    InputStream is = GlmMojoReaderTest.class.getResourceAsStream("model.ini");
                    return new BufferedReader(new InputStreamReader(is));
                }
                return new BufferedReader(new StringReader("d1\nd2\nd3\n"));
            }

            public byte[] getBinaryFile(String filename) throws IOException {
                throw new UnsupportedOperationException("Not expected");
            }

            public boolean exists(String name) {
                throw new UnsupportedOperationException("Not expected");
            }
        });
        Assert.assertTrue((boolean)model._useAllFactorLevels);
        Assert.assertEquals((long)1L, (long)model._cats);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])model._catModes);
        Assert.assertArrayEquals((int[])new int[]{0, 3}, (int[])model._catOffsets);
        Assert.assertEquals((long)7L, (long)model._nums);
        Assert.assertArrayEquals((double[])new double[]{0.5239, 0.4078, 0.1395, 0.8287, 0.35936, 0.1805, 0.2388}, (double[])model._numMeans, (double)0.001);
        Assert.assertTrue((boolean)model._meanImputation);
        Assert.assertArrayEquals((double[])new double[]{0.1165, -0.7141, 0.169, 0.0, 10.3898, 10.8657, 7.2552, -17.9726, -8.7421, 10.6995, 3.7805}, (double[])model._beta, (double)0.001);
        Assert.assertEquals((Object)"gaussian", (Object)model._family);
        Assert.assertEquals((Object)"identity", (Object)model._link);
    }

    @Test
    public void makeMultinomialModel() throws Exception {
        String[] cols = new String[]{"a", "b"};
        String[][] domain = new String[][]{};
        GlmMojoModelBase model = new GlmMojoReader(){

            protected String readkv(String key) {
                if (!"family".equals(key)) {
                    throw new UnsupportedOperationException("Unexpected property: " + key);
                }
                return "multinomial";
            }
        }.makeModel(cols, domain, "c");
        Assert.assertTrue((boolean)(model instanceof GlmMultinomialMojoModel));
        Assert.assertTrue((cols == model._names ? 1 : 0) != 0);
        Assert.assertTrue((domain == model._domains ? 1 : 0) != 0);
    }
}

