/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.kmeans;

import com.google.common.io.ByteStreams;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.kmeans.KMeansMojoReader;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KMeansMojoModelTest {
    private MojoModel _mojo;
    private double[][] _rows;
    private RowData[] _rowData;

    @Before
    public void setup() throws IOException {
        this._mojo = KMeansMojoReader.readFrom((MojoReaderBackend)new ClasspathReaderBackend());
        this._rows = new double[][]{{2.0, 1.0, 22.0, 1.0, 0.0}, {2.0, 1.0, 2.0, 3.0, 1.0}, {2.0, 0.0, 27.0, 0.0, 2.0}};
        this._rowData = new RowData[this._rows.length];
        for (int i = 0; i < this._rows.length; ++i) {
            this._rowData[i] = KMeansMojoModelTest.toRowData(this._mojo, this._rows[i]);
        }
    }

    @Test
    public void testPredict() throws Exception {
        EasyPredictModelWrapper wrapper = new EasyPredictModelWrapper((GenModel)this._mojo);
        for (int i = 0; i < 3; ++i) {
            ClusteringModelPrediction p = (ClusteringModelPrediction)wrapper.predict(this._rowData[i]);
            Assert.assertEquals((long)i, (long)p.cluster);
            double[] preds = new double[1];
            this._mojo.score0(this._rows[i], preds);
            Assert.assertEquals((double)i, (double)preds[0], (double)0.0);
        }
    }

    private static RowData toRowData(MojoModel mojo, double[] row) {
        RowData rowData = new RowData();
        for (String name : mojo._names) {
            int idx = mojo.getColIdx(name);
            String[] domain = mojo.getDomainValues(idx);
            if (domain != null) {
                rowData.put((Object)name, (Object)domain[(int)row[idx]]);
                continue;
            }
            rowData.put((Object)name, (Object)row[idx]);
        }
        return rowData;
    }

    private static class ClasspathReaderBackend
    implements MojoReaderBackend {
        private ClasspathReaderBackend() {
        }

        public BufferedReader getTextFile(String filename) throws IOException {
            InputStream is = KMeansMojoModelTest.class.getResourceAsStream(filename);
            return new BufferedReader(new InputStreamReader(is));
        }

        public byte[] getBinaryFile(String filename) throws IOException {
            InputStream is = KMeansMojoModelTest.class.getResourceAsStream(filename);
            return ByteStreams.toByteArray((InputStream)is);
        }

        public boolean exists(String filename) {
            return true;
        }
    }
}

