/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.word2vec;

import com.google.common.io.ByteStreams;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.word2vec.Word2VecMojoReader;
import hex.genmodel.algos.word2vec.WordEmbeddingModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;

public class Word2VecMojoModelTest {
    @Test
    public void testTransform0() throws Exception {
        MojoModel mojo = Word2VecMojoReader.readFrom((MojoReaderBackend)new ClasspathReaderBackend());
        Assert.assertTrue((boolean)(mojo instanceof WordEmbeddingModel));
        WordEmbeddingModel m = (WordEmbeddingModel)mojo;
        Assert.assertEquals((long)3L, (long)m.getVecSize());
        Assert.assertArrayEquals((float[])new float[]{0.0f, 1.0f, 0.2f}, (float[])m.transform0("a", new float[3]), (float)1.0E-4f);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 0.0f, 0.8f}, (float[])m.transform0("b", new float[3]), (float)1.0E-4f);
        Assert.assertNull((Object)m.transform0("c", new float[3]));
    }

    private static class ClasspathReaderBackend
    implements MojoReaderBackend {
        private ClasspathReaderBackend() {
        }

        public BufferedReader getTextFile(String filename) throws IOException {
            InputStream is = Word2VecMojoModelTest.class.getResourceAsStream(filename);
            return new BufferedReader(new InputStreamReader(is));
        }

        public byte[] getBinaryFile(String filename) throws IOException {
            InputStream is = Word2VecMojoModelTest.class.getResourceAsStream(filename);
            return ByteStreams.toByteArray((InputStream)is);
        }

        public boolean exists(String filename) {
            return true;
        }
    }
}

