/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.word2vec;

import hex.genmodel.algos.word2vec.Word2VecMojoModel;
import hex.genmodel.algos.word2vec.Word2VecMojoReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class Word2VecMojoReaderTest {
    @Test
    public void readModelData() throws Exception {
        TestedWord2VecMojoReader reader = new TestedWord2VecMojoReader();
        reader.readModelData();
        Word2VecMojoModel model = reader.getModel();
        Assert.assertArrayEquals((float[])new float[]{0.0f, 1.0f}, (float[])model.transform0("A", new float[2]), (float)1.0E-4f);
        Assert.assertArrayEquals((float[])new float[]{2.0f, 3.0f}, (float[])model.transform0("B", new float[2]), (float)1.0E-4f);
        Assert.assertArrayEquals((float[])new float[]{4.0f, 5.0f}, (float[])model.transform0("C", new float[2]), (float)1.0E-4f);
    }

    private static class TestedWord2VecMojoReader
    extends Word2VecMojoReader {
        private TestedWord2VecMojoReader() {
            this._model = new Word2VecMojoModel(new String[0], (String[][])new String[0][], null);
        }

        protected <T> T readkv(String key, T defVal) {
            Integer result = null;
            if ("vocab_size".equals(key)) {
                result = 3;
            } else if ("vec_size".equals(key)) {
                result = 2;
            }
            return (T)result;
        }

        protected byte[] readblob(String name) throws IOException {
            byte[] data = new byte[24];
            ByteBuffer bb = ByteBuffer.wrap(data);
            for (int i = 0; i < 6; ++i) {
                bb.putFloat(i);
            }
            return bb.array();
        }

        protected boolean exists(String name) {
            return true;
        }

        protected Iterable<String> readtext(String name, boolean unescapeNewlines) throws IOException {
            Assert.assertTrue((boolean)unescapeNewlines);
            return Arrays.asList("A", "B", "C");
        }

        private Word2VecMojoModel getModel() {
            return (Word2VecMojoModel)this._model;
        }
    }
}

