/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public class ParseUtils {
    public static double[] parseArrayOfDoubles(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        double[] res = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Double.parseDouble(parts[i].trim());
        }
        return res;
    }

    public static int[] parseArrayOfInts(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        int[] res = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Integer.parseInt(parts[i].trim());
        }
        return res;
    }

    public static Object tryParse(String input, Object defVal) {
        if (input.equals("null")) {
            return defVal;
        }
        if (defVal instanceof Boolean) {
            return Boolean.valueOf(input);
        }
        if (input.equals("true")) {
            return true;
        }
        if (input.equals("false")) {
            return false;
        }
        if ("[]".equals(input) && defVal != null && defVal.getClass().isArray()) {
            return defVal;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            if (defVal instanceof Number && !(defVal instanceof Double) && !(defVal instanceof Float)) {
                throw e;
            }
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException e2) {
                if (defVal instanceof Number) {
                    throw e2;
                }
                try {
                    return ParseUtils.parseArrayOfInts(input);
                }
                catch (NumberFormatException e3) {
                    if (defVal instanceof int[]) {
                        throw e3;
                    }
                    try {
                        return ParseUtils.parseArrayOfDoubles(input);
                    }
                    catch (NumberFormatException e4) {
                        if (defVal instanceof double[]) {
                            throw e4;
                        }
                        return input;
                    }
                }
            }
        }
    }
}

