/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryService;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.MojoRow;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.frame.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MojoFrameBuilder {
    public static final StringConverter DEFAULT_CONVERTER = new StringConverter(){

        @Override
        public Object convert(String s, MojoColumn.Type outputType) {
            return outputType.parse(s);
        }
    };
    private MojoFrameMeta _meta;
    private Set<String> _missingValues;
    private MojoColumnBuilder[] _columnBuilders;
    private StringConverter[] _stringConverters;

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Collection<String> missingValues) {
        this(frameMeta, missingValues, new HashMap<String, StringConverter>(0));
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Collection<String> missingValues, Map<String, StringConverter> stringConverters) {
        this._meta = frameMeta;
        MojoColumn.Type[] columnTypes = frameMeta.getColumnTypes();
        String[] columnNames = frameMeta.getColumnNames();
        this._missingValues = missingValues != null ? new HashSet<String>(missingValues) : new HashSet<String>(0);
        this._columnBuilders = new MojoColumnBuilder[frameMeta.size()];
        this._stringConverters = new StringConverter[frameMeta.size()];
        for (int i = 0; i < this._columnBuilders.length; ++i) {
            this._columnBuilders[i] = new MojoColumnBuilder(columnTypes[i]);
            String name = columnNames[i];
            this._stringConverters[i] = stringConverters.containsKey(name) ? stringConverters.get(name) : DEFAULT_CONVERTER;
        }
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta) {
        this(frameMeta, Collections.emptyList());
    }

    public MojoRowBuilder addRow(MojoRowBuilder rowBuilder) {
        this.addRow(rowBuilder.toMojoRow());
        rowBuilder.clear();
        return rowBuilder;
    }

    MojoFrameBuilder addRow(MojoRow row) {
        Object[] values = row.getValues();
        if (values.length != this._columnBuilders.length) {
            throw new IllegalArgumentException("Row argument does not have the same column count as frame");
        }
        for (int i = 0; i < this._columnBuilders.length; ++i) {
            this._columnBuilders[i].pushValue(values[i]);
        }
        return this;
    }

    public MojoRowBuilder getMojoRowBuilder() {
        return this.getMojoRowBuilder(false);
    }

    public MojoRowBuilder getMojoRowBuilder(boolean strictMode) {
        return new MojoRowBuilder(this._meta.getColumnNamesMap(), this._meta.getColumnTypes(), this._missingValues, this._stringConverters, strictMode);
    }

    public MojoFrame toMojoFrame() {
        MojoColumn[] columns = new MojoColumn[this._columnBuilders.length];
        int nrows = this._columnBuilders.length == 0 ? 0 : this._columnBuilders[0].size();
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this._columnBuilders[i].toMojoColumn();
        }
        return new MojoFrame(this._meta, columns, nrows);
    }

    public static MojoFrame getEmpty(MojoFrameMeta meta, int nrows) {
        MojoColumn.Type[] types = meta.getColumnTypes();
        MojoColumn[] columns = new MojoColumn[meta.size()];
        for (int i = 0; i < meta.size(); ++i) {
            columns[i] = MojoColumnFactoryService.getInstance().getMojoColumnFactory().create(types[i], nrows);
        }
        return new MojoFrame(meta, columns, nrows);
    }

    public static MojoFrame fromFrames(MojoFrameMeta meta, MojoFrame ... frames) {
        int ncols = 0;
        int nrows = frames.length == 0 ? 0 : frames[0].getNrows();
        for (MojoFrame f : frames) {
            if (f.getNrows() != nrows && f.getNcols() != 0) {
                throw new IllegalArgumentException("Number of rows in frames do not match");
            }
            ncols += f.getNcols();
        }
        if (ncols != meta.size()) {
            throw new IllegalArgumentException("Total number of columns in frames does not equal size of frame meta");
        }
        MojoColumn[] columns = new MojoColumn[ncols];
        MojoColumn.Type[] types = meta.getColumnTypes();
        int curr = 0;
        for (MojoFrame f : frames) {
            for (int i = 0; i < f.getNcols(); ++i) {
                MojoColumn col = f.getColumn(i);
                if (col.getType() != types[curr]) {
                    throw new IllegalArgumentException("Type of column " + curr + " does not match frame meta");
                }
                columns[curr] = f.getColumn(i);
                ++curr;
            }
        }
        return new MojoFrame(meta, columns, nrows);
    }

    public static MojoFrame fromColumns(MojoFrameMeta meta, MojoColumn[] columns) {
        if (columns.length != meta.size()) {
            throw new IllegalArgumentException("Number of columns does not match size of frame meta");
        }
        int nrows = columns.length == 0 ? 0 : columns[0].size();
        MojoColumn.Type[] types = meta.getColumnTypes();
        for (int i = 0; i < columns.length; ++i) {
            MojoColumn c = columns[i];
            if (c.size() != nrows) {
                throw new IllegalArgumentException("Number of rows in columns do not match");
            }
            if (c.getType() == types[i]) continue;
            throw new IllegalArgumentException("Type of column " + i + " does not match frame meta");
        }
        return new MojoFrame(meta, columns, nrows);
    }

    private class MojoColumnBuilder {
        private MojoColumn.Type _type;
        private List<Object> _vals;

        MojoColumnBuilder(MojoColumn.Type type) {
            this._type = type;
            this._vals = new ArrayList<Object>();
        }

        void pushValue(Object value) {
            this._vals.add(value == null ? this._type.NULL : value);
        }

        MojoColumn toMojoColumn() {
            MojoColumn col = MojoColumnFactoryService.getInstance().getMojoColumnFactory().create(this._type, this._vals.size());
            col.fillFromParsedListData(this._vals);
            return col;
        }

        int size() {
            return this._vals.size();
        }
    }
}

