/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.readers;

import ai.h2o.mojos.runtime.readers.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InMemoryMojoReaderBackend
extends MojoReaderBackend {
    private static final Map<String, byte[]> CLOSED = Collections.unmodifiableMap(new HashMap());
    private Map<String, byte[]> _mojoContent;

    public InMemoryMojoReaderBackend(Map<String, byte[]> mojoContent) {
        this(mojoContent, null);
    }

    public InMemoryMojoReaderBackend(Map<String, byte[]> mojoContent, String baseDir) {
        this(mojoContent, baseDir, null);
    }

    public InMemoryMojoReaderBackend(Map<String, byte[]> mojoContent, String baseDir, String separator) {
        this(mojoContent, baseDir, separator, null);
    }

    public InMemoryMojoReaderBackend(Map<String, byte[]> mojoContent, String baseDir, String separator, String pipelineFileName) {
        super(baseDir, separator, pipelineFileName);
        this._mojoContent = mojoContent;
    }

    @Override
    public InputStream getFile(String filename) throws IOException {
        this.assertOpen();
        byte[] data = this.getBinaryFile(filename);
        if (data == null) {
            throw new IOException("MOJO doesn't contain resource " + filename);
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        this.assertOpen();
        return new BufferedReader(new InputStreamReader(this.getFile(filename)));
    }

    @Override
    public byte[] getBinaryFile(String filename) {
        this.assertOpen();
        return this._mojoContent.get(this.filenameToPath(filename));
    }

    @Override
    public String[] getFileNames(String path) {
        this.assertOpen();
        path = this.filenameToPath(path);
        if (!path.isEmpty() && !path.endsWith(this.getSeparator())) {
            path = path + this.getSeparator();
        }
        HashSet<String> fileNames = new HashSet<String>();
        for (String dir : this._mojoContent.keySet()) {
            String f;
            if (!dir.startsWith(path) || (f = dir.substring(path.length())).contains(this.getSeparator())) continue;
            fileNames.add(f);
        }
        String[] out = new String[fileNames.size()];
        fileNames.toArray(out);
        return out;
    }

    @Override
    public String[] getDirectoryNames(String path) {
        this.assertOpen();
        path = this.filenameToPath(path);
        if (!path.isEmpty() && !path.endsWith(this.getSeparator())) {
            path = path + this.getSeparator();
        }
        HashSet<String> dirNames = new HashSet<String>();
        for (String dir : this._mojoContent.keySet()) {
            int dirEnd;
            if (!dir.startsWith(path) || (dirEnd = dir.indexOf(this.getSeparator(), path.length())) == -1) continue;
            dirNames.add(dir.substring(path.length(), dirEnd + this.getSeparator().length()));
        }
        String[] out = new String[dirNames.size()];
        dirNames.toArray(out);
        return out;
    }

    @Override
    public boolean exists(String filename) {
        return this._mojoContent.containsKey(this.filenameToPath(filename));
    }

    @Override
    public void close() {
        this._mojoContent = CLOSED;
    }

    private void assertOpen() {
        if (this._mojoContent == CLOSED) {
            throw new IllegalStateException("ReaderBackend was already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InMemoryMojoReaderBackend createFrom(InputStream inputStream) throws IOException {
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        ZipInputStream zis = new ZipInputStream(inputStream);
        PipelineType pipelineType = PipelineType.NONE;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("File too large: " + entry.getName());
                }
                if (!entry.isDirectory()) {
                    String entryFilename = entry.getName();
                    if (entryFilename.equals(DEFAULT_PROTO_PIPELINE_FILE_PATH)) {
                        pipelineType = PipelineType.PROTO;
                    } else if (entryFilename.equals(DEFAULT_TOML_PIPELINE_FILE_PATH)) {
                        pipelineType = PipelineType.TOML;
                    }
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                InMemoryMojoReaderBackend.copyStream(zis, os);
                content.put(entry.getName(), os.toByteArray());
            }
        }
        finally {
            InMemoryMojoReaderBackend.closeQuietly(zis);
        }
        switch (pipelineType) {
            case TOML: {
                return new InMemoryMojoReaderBackend(content, DEFAULT_BASE_DIR, "/", DEFAULT_TOML_PIPELINE_FILENAME);
            }
            case PROTO: {
                return new InMemoryMojoReaderBackend(content);
            }
        }
        throw new IOException("Cannot find any pipeline file!");
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void copyStream(InputStream source, OutputStream target) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = source.read(buffer)) != -1) {
            target.write(buffer, 0, len);
        }
    }

    private String filenameToPath(String filename) {
        return this.getBaseDir() + filename;
    }

    private static enum PipelineType {
        NONE,
        TOML,
        PROTO;

    }
}

