/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.readers;

import ai.h2o.mojos.runtime.readers.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MojofileMojoReaderBackend
extends MojoReaderBackend {
    private final ZipFile _zf;

    public MojofileMojoReaderBackend(String archivename) throws IOException {
        this(archivename, null);
    }

    public MojofileMojoReaderBackend(String archivename, String baseDir) throws IOException {
        this(archivename, baseDir, null);
    }

    public MojofileMojoReaderBackend(String archivename, String baseDir, String pipelineFileName) throws IOException {
        super(baseDir, "/", pipelineFileName);
        this._zf = new ZipFile(archivename);
    }

    @Override
    public InputStream getFile(String filename) throws IOException {
        return this._zf.getInputStream(this.getEntry(filename));
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        InputStream input = this.getFile(filename);
        return new BufferedReader(new InputStreamReader(input));
    }

    @Override
    public byte[] getBinaryFile(String filename) throws IOException {
        ZipEntry entry = this.getEntry(filename);
        byte[] out = new byte[(int)entry.getSize()];
        DataInputStream dis = new DataInputStream(this._zf.getInputStream(entry));
        dis.readFully(out);
        return out;
    }

    @Override
    public String[] getFileNames(String path) {
        if (!(path = this.filenameToPath(path)).isEmpty() && !path.endsWith(this.getSeparator())) {
            path = path + this.getSeparator();
        }
        HashSet<String> fileNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this._zf.entries();
        while (entries.hasMoreElements()) {
            String f;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(path) || (f = entryName.substring(path.length())).contains(this.getSeparator())) continue;
            fileNames.add(f);
        }
        String[] out = new String[fileNames.size()];
        fileNames.toArray(out);
        return out;
    }

    @Override
    public String[] getDirectoryNames(String path) {
        if (!(path = this.filenameToPath(path)).isEmpty() && !path.endsWith(this.getSeparator())) {
            path = path + this.getSeparator();
        }
        HashSet<String> dirNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this._zf.entries();
        while (entries.hasMoreElements()) {
            int dirEnd;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(path) || (dirEnd = entryName.indexOf(this.getSeparator(), path.length())) == -1) continue;
            dirNames.add(entryName.substring(path.length(), dirEnd + this.getSeparator().length()));
        }
        String[] out = new String[dirNames.size()];
        dirNames.toArray(out);
        return out;
    }

    @Override
    public void close() throws IOException {
        this._zf.close();
    }

    @Override
    public boolean exists(String filename) {
        return this._zf.getEntry(this.filenameToPath(filename)) != null;
    }

    private ZipEntry getEntry(String filename) throws IOException {
        ZipEntry ze = this._zf.getEntry(this.filenameToPath(filename));
        if (ze == null) {
            throw new IOException("Tree file '" + this.filenameToPath(filename) + "' not found");
        }
        return ze;
    }

    private String filenameToPath(String filename) {
        return this.getBaseDir() + filename;
    }
}

