package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.lic.LicenseException;
import java.io.IOException;

public interface PipelineLoaderFactory {
    /**
     * Creates the loader with a given backend
     * @param backend -
     * @param optionalMainFile primary file to load; if null, the one from {@link #getRootResource()} must be used.
     *                         Can be occasionally used with different values, for instance for nested pipelines.
     * @return the pipeline loader; never returns null
     * @throws IOException -
     * @throws LicenseException -
     */
    PipelineLoader createLoader(ReaderBackend backend, String optionalMainFile) throws IOException, LicenseException;

    /**
     * @return simple, constant identification of the loader; like "protobuf" or "toml". Used for debugging,
     * and explicit specification of loader detection order - see {@link MojoPipelineService}.
     */
    String getName();

    /**
     * Primary root resource. It is used a) for determining if that backend can be used to {@link #createLoader(ReaderBackend, String) create a loader} with this factory,
     * and if so, it is passed to the loader as the primary file to load.
     * @return path to primary file inside a {@link ReaderBackend}
     */
    String getRootResource();
}
