package ai.h2o.mojos.runtime.api.backend;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

/** Represents access to a storage */
public interface ReaderBackend extends Closeable {

    ResourceInfo getResourceInfo(String resourceName) throws IOException;

    /**
     * @param resourceName -
     * @return binary representation of the resource in form of a stream
     * @throws IOException -
     */
    InputStream getInputStream(String resourceName) throws IOException;

    /**
     * @param resourceName -
     * @return true if such resource exists
     */
    boolean exists(String resourceName);

    /**
     * @return list of all contained resources
     */
    Collection<String> list();
}
