package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents all metadata about a column.
 * It can be input feature, intermediate result, or output column.
 *
 * Does NOT contain values - for that, see {@link ai.h2o.mojos.runtime.frame.MojoColumn} and its descendants.
 */
public class MojoColumnMeta {
    private final String columnName;
    private final MojoColumn.Type columnType;

    private MojoColumnMeta(String columnName, MojoColumn.Type columnType) {
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public static MojoColumnMeta create(String columnName, MojoColumn.Type columnType) {
        return new MojoColumnMeta(columnName, columnType);
    }

    /**
     * @deprecated use {@link #create(String, MojoColumn.Type)} instead
     */
    @Deprecated
    public static MojoColumnMeta newInput(String columnName, MojoColumn.Type columnType) {
        return create(columnName, columnType);
    }

    /**
     * @deprecated use {@link #create(String, MojoColumn.Type)} instead
     */
    @Deprecated
    public static MojoColumnMeta newOutput(String name, MojoColumn.Type columnType) {
        return create(name, columnType);
    }

    /**
     * Compatibility helper. You should preferably construct {@link List} of columns as standard java collection, and then pass it to {@link ai.h2o.mojos.runtime.frame.MojoFrameMeta}.
     */
    public static List<MojoColumnMeta> toColumns(final String[] columnNames, final MojoColumn.Type[] columnTypes) {

        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("columnNames and columnTypes arguments must have the same length");
        }
        final List<MojoColumnMeta> cols = new ArrayList<>();
        for (int i = 0; i < columnNames.length; i++) {
            final MojoColumnMeta col = create(columnNames[i], columnTypes[i]);
            cols.add(col);
        }
        return cols;
    }

    /**
     * @deprecated use {@link #toColumns(String[], MojoColumn.Type[])} instead
     */
    @Deprecated
    public static List<MojoColumnMeta> toColumns(final String[] columnNames, final MojoColumn.Type[] columnTypes, final MojoColumn.Kind kind_ignored) {
        return toColumns(columnNames, columnTypes);
    }

    public String getColumnName() {
        return columnName;
    }

    public MojoColumn.Type getColumnType() {
        return columnType;
    }

    @Override
    public String toString() {
        return columnName + ":" + columnType;
    }

    /**
     * It is essential that both this and {@link #hashCode()} remain instance-based, and definitely not name-based.
     * For that reason, the override here is explicit and calls derived code.
     */
    @Override
    public boolean equals(final Object o) {
        // DO NOT CHANGE!
        return super.equals(o);
    }

    /**
     * It is essential that both {@link #equals(Object)} and this remain instance-based, and definitely not name-based.
     * For that reason, the override here is explicit and calls derived code.
     */
    @Override
    public int hashCode() {
        // DO NOT CHANGE!
        return super.hashCode();
    }
}
