package ai.h2o.mojos.runtime.api;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoTransformationGroup {
    private static final Logger log = LoggerFactory.getLogger(MojoTransformationGroup.class);
    private final String id;
    private final String name;

    public MojoTransformationGroup(final String id, final String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(final Map<String, MojoTransformationGroup> groups, final String groupId) {
        if (groupId == null) return null;
        MojoTransformationGroup group = groups.get(groupId);
        if (group == null) {
            log.warn("Undefined group ID: {}", groupId); // this will unlikely ever happen (corrupted mojo only)
            group = new MojoTransformationGroup(groupId, String.format("#undefined#%s", groupId));
            groups.put(groupId, group);
        }
        return group;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final MojoTransformationGroup that = (MojoTransformationGroup) o;
        return id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return String.format("G:%s{%s}", id, name);
    }
}
