/**
 * The package exposes classes to support frame and row creation.
 *
 * The package expose the following concepts:
 *
 *   - {@link ai.h2o.mojos.runtime.frame.MojoFrame}
 *   - {@link ai.h2o.mojos.runtime.frame.MojoFrameBuilder}
 *   - {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder}
 *
 * The {@link ai.h2o.mojos.runtime.frame.MojoFrame} represents data which are
 * transformed by {@link ai.h2o.mojos.runtime.MojoPipeline}. The frame consists of
 * columns {@link ai.h2o.mojos.runtime.frame.MojoColumn},
 * each column has defined type {@link ai.h2o.mojos.runtime.frame.MojoColumn.Type}.
 *
 * The {@link ai.h2o.mojos.runtime.frame.MojoFrame}
 * is constructed with help of {@link ai.h2o.mojos.runtime.frame.MojoFrameBuilder}.
 * The builder which helps to create input frame for a given MOJO pipeline can be obtain by calling
 * {@link ai.h2o.mojos.runtime.MojoPipeline#getInputFrameBuilder()}.
 *
 * The frame builder provides a method {@link ai.h2o.mojos.runtime.frame.MojoFrameBuilder#getMojoRowBuilder()}
 * to obtain an instance of {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder}. The row builder helps
 * to create representation of row. The row constructed by the row builder, is appended to the frame builder
 * by calling method {@link ai.h2o.mojos.runtime.frame.MojoFrameBuilder#addRow(ai.h2o.mojos.runtime.frame.MojoRowBuilder)}.
 *
 * The row can be constructed in two ways:
 *
 *   - by passing a string representation of value for a particular column to method {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder#setValue(int, java.lang.String)}.
 *     This method internally transform the string representation into actual column type
 *   - by using a strongly typed methods `setX(int columnIndex, X value)` where X is Java type compatible with MOJO column type.
 *     For example, {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder#setBool(int, java.lang.Boolean)} allows to set boolean value for a given column.
 *
 * Note: Instances of {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder} can be reused after calling {@link ai.h2o.mojos.runtime.frame.MojoRowBuilder}
 *
 * ---
 *
 * Example:
 *
 * Given a pipeline `modelPipeline` we can construct an input frame in the following way:
 *
 * ```java
 * // Get an input frame builder for given modelPipeline
 * MojoFrameBuilder frameBuilder = modelPipeline.getInputFrameBuilder();
 *
 * // Create a new row builder
 * MojoRowBuilder rowBuilder = frameBuilder.getMojoRowBuilder();
 * rowBuilder.setValue("AGE", "68");
 * rowBuilder.setValue("RACE", "2");
 * rowBuilder.setValue("DCAPS", "2");
 * rowBuilder.setValue("VOL", "0");
 * rowBuilder.setValue("GLEASON", "6");
 * frameBuilder.addRow(rowBuilder);
 *
 * // Create a frame which can be transformed by MOJO pipeline
 * MojoFrame iframe = frameBuilder.toMojoFrame();
 *
 * // Transform frame by the given modelPipeline:
 * MojoFrame oframe = modelPipeline.transform(iframe);
 * ```
 */
package ai.h2o.mojos.runtime.frame;