package ai.h2o.mojos.runtime.lic;

/**
 * The exception reports an invalid MOJO signature.
 *
 * The invalid MOJO signature means, that the signature file
 * ({@link MojoSignatureConsts#MOJO_SIGNATURE_FILENAME }) is present,
 * but the signature does not match expected signature of
 * MOJO watermark file ({@link MojoSignatureConsts#MOJO_WATERMARK_FILENAME}).
 *
 * That means that the signature or watermark file was modified.
 */
public class InvalidSignatureException extends LicenseException {

  public InvalidSignatureException(Exception e) {
    super("Invalid MOJO signature! It seems like MOJO was modified!", e);
  }

  public InvalidSignatureException() {
    this(null);
  }
}
