package ai.h2o.mojos.runtime.lic;

/**
 * The exception reports an invalid MOJO watermark (non-perpetual MOJO).
 *
 * The invalid watermark means that the MOJO is not marked as perpetual.
 */
public class InvalidWatermarkException extends LicenseException {

  public InvalidWatermarkException(Exception e) {
    super("Invalid MOJO watermark! This is not a perpetual MOJO!", e);
  }

  public InvalidWatermarkException() {
    this(null);
  }
}
