/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.AutoMLBuildSpec;
import hex.ScoreKeeper;
import java.io.IOException;
import java.util.Date;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.h2o.algos.H2OAutoML$;
import org.apache.spark.ml.h2o.algos.H2OAutoMLAlgosParam;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams;
import org.apache.spark.ml.h2o.algos.H2OAutoMLParams$class;
import org.apache.spark.ml.h2o.algos.H2OAutoMLStoppingMetricParam;
import org.apache.spark.ml.h2o.algos.H2OAutoMLWriter;
import org.apache.spark.ml.h2o.algos.NullableFloatArrayParam;
import org.apache.spark.ml.h2o.models.H2OMOJOModel;
import org.apache.spark.ml.h2o.param.NullableStringParam;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.FloatParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import water.DKV;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.support.H2OFrameSupport$;
import water.support.ModelSerializationSupport$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001=\u0011\u0011\u0002\u0013\u001aP\u0003V$x.\u0014'\u000b\u0005\r!\u0011!B1mO>\u001c(BA\u0003\u0007\u0003\rA'g\u001c\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!i\u0001\u0003cA\t\u0013)5\ta!\u0003\u0002\u0014\r\tIQi\u001d;j[\u0006$xN\u001d\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\ta!\\8eK2\u001c\u0018BA\r\u0017\u00051A%gT'P\u0015>ku\u000eZ3m!\tYb$D\u0001\u001d\u0015\tib!\u0001\u0003vi&d\u0017BA\u0010\u001d\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011q\u0002\u0013\u001aP\u0003V$x.\u0014'QCJ\fWn\u001d\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005y\u0011-\u001e;p[2\u0014U/\u001b7e'B,7-F\u0001(!\rA3&L\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1q\n\u001d;j_:\u0004\"A\f\u001b\u000e\u0003=R!\u0001M\u0019\u0002\r\u0005,Ho\\7m\u0015\t)!GC\u00014\u0003\t\t\u0017.\u0003\u00026_\ty\u0011)\u001e;p\u001b2\u0013U/\u001b7e'B,7\r\u0003\u00058\u0001\t\u0005\t\u0015!\u0003(\u0003A\tW\u000f^8nY\n+\u0018\u000e\u001c3Ta\u0016\u001c\u0007\u0005\u0003\u0005:\u0001\t\u0015\r\u0011\"\u0011;\u0003\r)\u0018\u000eZ\u000b\u0002wA\u0011Ah\u0010\b\u0003QuJ!AP\u0015\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}%B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaO\u0001\u0005k&$\u0007\u0005\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0003\tA7\r\u0005\u0002H\u00136\t\u0001J\u0003\u0002\u0006\u0011%\u0011!\n\u0013\u0002\u000b\u0011Jz5i\u001c8uKb$\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b1B'\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\u0011\u0005\u00191/\u001d7\n\u0005I{%AC*R\u0019\u000e{g\u000e^3yi\")A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"2A\u0016.\\)\r9\u0006,\u0017\t\u0003C\u0001AQ!R*A\u0004\u0019CQ\u0001T*A\u00045CQ!J*A\u0002\u001dBQ!O*A\u0002mBQ\u0001\u0016\u0001\u0005\u0002u#\u0012A\u0018\u000b\u0004/~\u0003\u0007\"B#]\u0001\b1\u0005\"\u0002']\u0001\bi\u0005\"\u0002+\u0001\t\u0003\u0011G\u0003B,dI\u0016DQ!O1A\u0002mBQ!R1A\u0002\u0019CQ\u0001T1A\u00025CQa\u001a\u0001\u0005B!\f1AZ5u)\t!\u0012\u000eC\u0003kM\u0002\u00071.A\u0004eCR\f7/\u001a;1\u00051\f\bc\u0001(n_&\u0011an\u0014\u0002\b\t\u0006$\u0018m]3u!\t\u0001\u0018\u000f\u0004\u0001\u0005\u0013IL\u0017\u0011!A\u0001\u0006\u0003\u0019(aA0%cE\u0011Ao\u001e\t\u0003QUL!A^\u0015\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0006_\u0005\u0003s&\u00121!\u00118z\u0011\u0015Y\b\u0001\"\u0001}\u0003)!(/Y5o\u001b>$W\r\u001c\u000b\u0003)uDQA >A\u0002}\f1!Y7m!\rq\u0013\u0011A\u0005\u0004\u0003\u0007y#AB!vi>lE\nC\u0004\u0002\b\u0001!\t%!\u0003\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a\u0003\u0002\u0018A!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012=\u000bQ\u0001^=qKNLA!!\u0006\u0002\u0010\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005e\u0011Q\u0001a\u0001\u0003\u0017\taa]2iK6\f\u0007\u0006BA\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GA\u0011AC1o]>$\u0018\r^5p]&!\u0011qEA\u0011\u00051!UM^3m_B,'/\u00119j\u0011\u001d\tY\u0003\u0001C!\u0003[\tAaY8qsR!\u0011qFA\u0019\u001b\u0005\u0001\u0001\u0002CA\u001a\u0003S\u0001\r!!\u000e\u0002\u000b\u0015DHO]1\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u0007\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ty$!\u000f\u0003\u0011A\u000b'/Y7NCBDq!a\u0011\u0001\t\u0003\n)%A\u0003xe&$X-\u0006\u0002\u0002HA\u00191$!\u0013\n\u0007\u0005-CD\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0019\t\t%a\u0014\u0002VA!\u0011qDA)\u0013\u0011\t\u0019&!\t\u0003\u000bMKgnY3\"\u0005\u0005]\u0013!B\u0019/m9\u0002\u0004BBA.\u0001\u0011\u0005!(A\beK\u001a\fW\u000f\u001c;GS2,g*Y7f\u000f\u001d\tyF\u0001E\u0001\u0003C\n\u0011\u0002\u0013\u001aP\u0003V$x.\u0014'\u0011\u0007\u0005\n\u0019G\u0002\u0004\u0002\u0005!\u0005\u0011QM\n\t\u0003G\n9'!\u001c\u0002tA\u0019\u0001&!\u001b\n\u0007\u0005-\u0014F\u0001\u0004B]f\u0014VM\u001a\t\u00057\u0005=t+C\u0002\u0002rq\u0011!\"\u0014'SK\u0006$\u0017M\u00197f!\rA\u0013QO\u0005\u0004\u0003oJ#\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002+\u0002d\u0011\u0005\u00111\u0010\u000b\u0003\u0003CB!\"a\u0017\u0002d\t\u0007IQBA@+\t\t\ti\u0004\u0002\u0002\u0004\u0006\u0012\u0011QQ\u0001\u000eCV$x.\u001c7`a\u0006\u0014\u0018-\\:\t\u0013\u0005%\u00151\rQ\u0001\u000e\u0005\u0005\u0015\u0001\u00053fM\u0006,H\u000e\u001e$jY\u0016t\u0015-\\3!\u0011!\ti)a\u0019\u0005B\u0005=\u0015\u0001\u0002:fC\u0012,\"!!%\u0011\tm\t\u0019jV\u0005\u0004\u0003+c\"\u0001C'M%\u0016\fG-\u001a:)\r\u0005-\u0015qJA+\u0011!\tY*a\u0019\u0005B\u0005u\u0015\u0001\u00027pC\u0012$2aVAP\u0011\u001d\t\t+!'A\u0002m\nA\u0001]1uQ\"2\u0011\u0011TA(\u0003+B!\"a*\u0002d\u0005\u0005I\u0011BAU\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\u0005Y\u0006twM\u0003\u0002\u00026\u0006!!.\u0019<b\u0013\u0011\tI,a,\u0003\r=\u0013'.Z2u\u0001")
public class H2OAutoML
extends Estimator<H2OMOJOModel>
implements MLWritable,
H2OAutoMLParams {
    private final Option<AutoMLBuildSpec> automlBuildSpec;
    private final String uid;
    private final H2OContext hc;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns;
    private final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    private final H2OAutoMLStoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa;
    private final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    private final NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    private final FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;

    public static H2OAutoML load(String string) {
        return H2OAutoML$.MODULE$.load(string);
    }

    public static MLReader<H2OAutoML> read() {
        return H2OAutoML$.MODULE$.read();
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical;
    }

    @Override
    public final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn;
    }

    @Override
    public final StringArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns;
    }

    @Override
    public final H2OAutoMLAlgosParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds;
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance;
    }

    @Override
    public final H2OAutoMLStoppingMetricParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa;
    }

    @Override
    public final IntParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses;
    }

    @Override
    public final NullableFloatArrayParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors;
    }

    @Override
    public final FloatParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels() {
        return this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$predictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$allStringColumnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$columnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ratio = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$foldColumn = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$weightsColumn = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$ignoredColumns = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos_$eq(H2OAutoMLAlgosParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$excludeAlgos = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$projectName = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxRuntimeSecs = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingRounds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingTolerance = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric_$eq(H2OAutoMLStoppingMetricParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$stoppingMetric = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$nfolds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$convertUnknownCategoricalLevelsToNa = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed_$eq(IntParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$seed = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$sortMetric = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$balanceClasses = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors_$eq(NullableFloatArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$classSamplingFactors = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize_$eq(FloatParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$maxAfterBalanceSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationPredictions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OAutoMLParams$_setter_$org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OAutoMLParams$$keepCrossValidationModels = x$1;
    }

    @Override
    public String getPredictionsCol() {
        return H2OAutoMLParams$class.getPredictionsCol(this);
    }

    @Override
    public boolean getAllStringColumnsToCategorical() {
        return H2OAutoMLParams$class.getAllStringColumnsToCategorical(this);
    }

    @Override
    public String[] getColumnsToCategorical() {
        return H2OAutoMLParams$class.getColumnsToCategorical(this);
    }

    @Override
    public double getRatio() {
        return H2OAutoMLParams$class.getRatio(this);
    }

    @Override
    public String getFoldColumn() {
        return H2OAutoMLParams$class.getFoldColumn(this);
    }

    @Override
    public String getWeightsColumn() {
        return H2OAutoMLParams$class.getWeightsColumn(this);
    }

    @Override
    public String[] getIgnoredColumns() {
        return H2OAutoMLParams$class.getIgnoredColumns(this);
    }

    @Override
    public AutoML.algo[] getExcludeAlgos() {
        return H2OAutoMLParams$class.getExcludeAlgos(this);
    }

    @Override
    public String getProjectName() {
        return H2OAutoMLParams$class.getProjectName(this);
    }

    @Override
    public double getMaxRuntimeSecs() {
        return H2OAutoMLParams$class.getMaxRuntimeSecs(this);
    }

    @Override
    public int getStoppingRounds() {
        return H2OAutoMLParams$class.getStoppingRounds(this);
    }

    @Override
    public double getStoppingTolerance() {
        return H2OAutoMLParams$class.getStoppingTolerance(this);
    }

    @Override
    public ScoreKeeper.StoppingMetric getStoppingMetric() {
        return H2OAutoMLParams$class.getStoppingMetric(this);
    }

    @Override
    public int getNfolds() {
        return H2OAutoMLParams$class.getNfolds(this);
    }

    @Override
    public boolean getConvertUnknownCategoricalLevelsToNa() {
        return H2OAutoMLParams$class.getConvertUnknownCategoricalLevelsToNa(this);
    }

    @Override
    public int getSeed() {
        return H2OAutoMLParams$class.getSeed(this);
    }

    @Override
    public String getSortMetric() {
        return H2OAutoMLParams$class.getSortMetric(this);
    }

    @Override
    public boolean getBalanceClasses() {
        return H2OAutoMLParams$class.getBalanceClasses(this);
    }

    @Override
    public float[] getClassSamplingFactors() {
        return H2OAutoMLParams$class.getClassSamplingFactors(this);
    }

    @Override
    public float getMaxAfterBalanceSize() {
        return H2OAutoMLParams$class.getMaxAfterBalanceSize(this);
    }

    @Override
    public boolean getKeepCrossValidationPredictions() {
        return H2OAutoMLParams$class.getKeepCrossValidationPredictions(this);
    }

    @Override
    public boolean getKeepCrossValidationModels() {
        return H2OAutoMLParams$class.getKeepCrossValidationModels(this);
    }

    @Override
    public H2OAutoMLParams setPredictionsCol(String value) {
        return H2OAutoMLParams$class.setPredictionsCol(this, value);
    }

    @Override
    public H2OAutoMLParams setAllStringColumnsToCategorical(boolean value) {
        return H2OAutoMLParams$class.setAllStringColumnsToCategorical(this, value);
    }

    @Override
    public H2OAutoMLParams setColumnsToCategorical(String first, Seq<String> others) {
        return H2OAutoMLParams$class.setColumnsToCategorical(this, first, others);
    }

    @Override
    public H2OAutoMLParams setColumnsToCategorical(String[] columns) {
        return H2OAutoMLParams$class.setColumnsToCategorical(this, columns);
    }

    @Override
    public H2OAutoMLParams setRatio(double value) {
        return H2OAutoMLParams$class.setRatio(this, value);
    }

    @Override
    public H2OAutoMLParams setFoldColumn(String value) {
        return H2OAutoMLParams$class.setFoldColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setWeightsColumn(String value) {
        return H2OAutoMLParams$class.setWeightsColumn(this, value);
    }

    @Override
    public H2OAutoMLParams setIgnoredColumns(String[] value) {
        return H2OAutoMLParams$class.setIgnoredColumns(this, value);
    }

    @Override
    public H2OAutoMLParams setExcludeAlgos(AutoML.algo[] value) {
        return H2OAutoMLParams$class.setExcludeAlgos(this, value);
    }

    @Override
    public H2OAutoMLParams setProjectName(String value) {
        return H2OAutoMLParams$class.setProjectName(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxRuntimeSecs(double value) {
        return H2OAutoMLParams$class.setMaxRuntimeSecs(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingRounds(int value) {
        return H2OAutoMLParams$class.setStoppingRounds(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingTolerance(double value) {
        return H2OAutoMLParams$class.setStoppingTolerance(this, value);
    }

    @Override
    public H2OAutoMLParams setStoppingMetric(ScoreKeeper.StoppingMetric value) {
        return H2OAutoMLParams$class.setStoppingMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setNfolds(int value) {
        return H2OAutoMLParams$class.setNfolds(this, value);
    }

    @Override
    public H2OAutoMLParams setConvertUnknownCategoricalLevelsToNa(boolean value) {
        return H2OAutoMLParams$class.setConvertUnknownCategoricalLevelsToNa(this, value);
    }

    @Override
    public H2OAutoMLParams setSeed(int value) {
        return H2OAutoMLParams$class.setSeed(this, value);
    }

    @Override
    public H2OAutoMLParams setSortMetric(String value) {
        return H2OAutoMLParams$class.setSortMetric(this, value);
    }

    @Override
    public H2OAutoMLParams setBalanceClasses(boolean value) {
        return H2OAutoMLParams$class.setBalanceClasses(this, value);
    }

    @Override
    public H2OAutoMLParams setClassSamplingFactors(float[] value) {
        return H2OAutoMLParams$class.setClassSamplingFactors(this, value);
    }

    @Override
    public H2OAutoMLParams setMaxAfterBalanceSize(float value) {
        return H2OAutoMLParams$class.setMaxAfterBalanceSize(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationPredictions(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationPredictions(this, value);
    }

    @Override
    public H2OAutoMLParams setKeepCrossValidationModels(boolean value) {
        return H2OAutoMLParams$class.setKeepCrossValidationModels(this, value);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public Option<AutoMLBuildSpec> automlBuildSpec() {
        return this.automlBuildSpec;
    }

    public String uid() {
        return this.uid;
    }

    public H2OMOJOModel fit(Dataset<?> dataset) {
        AutoMLBuildSpec spec = (AutoMLBuildSpec)this.automlBuildSpec().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AutoMLBuildSpec apply() {
                return new AutoMLBuildSpec();
            }
        });
        H2OFrame input = this.hc.asH2OFrame(dataset.toDF());
        if (this.getRatio() < 1.0) {
            Frame[] keys = H2OFrameSupport$.MODULE$.split((Frame)input, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Key.rand(), Key.rand()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.getRatio()})));
            spec.input_spec.training_frame = keys[0]._key;
            if (keys.length > 1) {
                spec.input_spec.validation_frame = keys[1]._key;
            }
        } else {
            spec.input_spec.training_frame = input._key;
        }
        Frame trainFrame = (Frame)spec.input_spec.training_frame.get();
        Object object = this.getAllStringColumnsToCategorical() ? H2OFrameSupport$.MODULE$.allStringVecToCategorical(trainFrame) : BoxedUnit.UNIT;
        H2OFrameSupport$.MODULE$.columnsToCategorical(trainFrame, this.getColumnsToCategorical());
        spec.input_spec.response_column = this.getPredictionsCol();
        spec.input_spec.fold_column = this.getFoldColumn();
        spec.input_spec.weights_column = this.getWeightsColumn();
        spec.input_spec.ignored_columns = this.getIgnoredColumns();
        spec.input_spec.sort_metric = this.getSortMetric();
        spec.build_models.exclude_algos = this.getExcludeAlgos();
        spec.build_control.project_name = this.getProjectName();
        spec.build_control.stopping_criteria.set_seed((long)this.getSeed());
        spec.build_control.stopping_criteria.set_max_runtime_secs(this.getMaxRuntimeSecs());
        spec.build_control.stopping_criteria.set_stopping_rounds(this.getStoppingRounds());
        spec.build_control.stopping_criteria.set_stopping_tolerance(this.getStoppingTolerance());
        spec.build_control.stopping_criteria.set_stopping_metric(this.getStoppingMetric());
        spec.build_control.nfolds = this.getNfolds();
        spec.build_control.balance_classes = this.getBalanceClasses();
        spec.build_control.class_sampling_factors = this.getClassSamplingFactors();
        spec.build_control.max_after_balance_size = this.getMaxAfterBalanceSize();
        spec.build_control.keep_cross_validation_predictions = this.getKeepCrossValidationPredictions();
        spec.build_control.keep_cross_validation_models = this.getKeepCrossValidationModels();
        DKV.put((Keyed)trainFrame);
        AutoML aml = new AutoML(Key.make((String)this.uid()), new Date(), spec);
        AutoML.startAutoML((AutoML)aml);
        aml.get();
        H2OMOJOModel model = this.trainModel(aml);
        model.setConvertUnknownCategoricalLevelsToNa(true);
        return model;
    }

    public H2OMOJOModel trainModel(AutoML aml) {
        return new H2OMOJOModel(ModelSerializationSupport$.MODULE$.getMojoData(aml.leader()));
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    public H2OAutoML copy(ParamMap extra) {
        return (H2OAutoML)this.defaultCopy(extra);
    }

    public MLWriter write() {
        return new H2OAutoMLWriter(this);
    }

    public String defaultFileName() {
        return "automl_params";
    }

    public H2OAutoML(Option<AutoMLBuildSpec> automlBuildSpec, String uid, H2OContext hc, SQLContext sqlContext) {
        this.automlBuildSpec = automlBuildSpec;
        this.uid = uid;
        this.hc = hc;
        MLWritable.class.$init$((MLWritable)this);
        H2OAutoMLParams$class.$init$(this);
    }

    public H2OAutoML(H2OContext hc, SQLContext sqlContext) {
        this((Option<AutoMLBuildSpec>)None$.MODULE$, Identifiable$.MODULE$.randomUID("automl"), hc, sqlContext);
    }

    public H2OAutoML(String uid, H2OContext hc, SQLContext sqlContext) {
        this((Option<AutoMLBuildSpec>)None$.MODULE$, uid, hc, sqlContext);
    }
}

