/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import hex.Model;
import hex.grid.Grid;
import hex.grid.GridSearch;
import hex.tree.gbm.GBMModel;
import java.io.IOException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.h2o.algos.GBMParametersParam;
import org.apache.spark.ml.h2o.algos.H2OGBM;
import org.apache.spark.ml.h2o.algos.H2OGridSearch$;
import org.apache.spark.ml.h2o.algos.H2OGridSearchParams;
import org.apache.spark.ml.h2o.algos.H2OGridSearchParams$class;
import org.apache.spark.ml.h2o.algos.H2OGridSearchWriter;
import org.apache.spark.ml.h2o.algos.HyperParamsParam;
import org.apache.spark.ml.h2o.models.H2OMOJOModel;
import org.apache.spark.ml.h2o.param.NullableStringParam;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import water.DKV;
import water.Job;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.support.H2OFrameSupport$;
import water.support.ModelSerializationSupport$;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001=\u0011Q\u0002\u0013\u001aP\u000fJLGmU3be\u000eD'BA\u0002\u0005\u0003\u0015\tGnZ8t\u0015\t)a!A\u0002ie=T!a\u0002\u0005\u0002\u00055d'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e!!\r\t\"\u0003F\u0007\u0002\r%\u00111C\u0002\u0002\n\u000bN$\u0018.\\1u_J\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\r5|G-\u001a7t\u0013\tIbC\u0001\u0007Ie=kuJS(N_\u0012,G\u000e\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\r\u0005!Q\u000f^5m\u0013\tyBD\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u0004\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003'!\u0013tj\u0012:jIN+\u0017M]2i!\u0006\u0014\u0018-\\:\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0001c\u001a:jIN+\u0017M]2i!\u0006\u0014\u0018-\\:\u0016\u0003\u001d\u00022\u0001K\u0016!\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB(qi&|g\u000e\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003(\u0003E9'/\u001b3TK\u0006\u00148\r\u001b)be\u0006l7\u000f\t\u0005\ta\u0001\u0011)\u0019!C!c\u0005\u0019Q/\u001b3\u0016\u0003I\u0002\"a\r\u001c\u000f\u0005!\"\u0014BA\u001b*\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005UJ\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\tULG\r\t\u0005\ty\u0001\u0011\t\u0011)A\u0006{\u0005\u0011\u0001n\u0019\t\u0003}\u0001k\u0011a\u0010\u0006\u0003\u000b!I!!Q \u0003\u0015!\u0013tjQ8oi\u0016DH\u000f\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\"\t1a]9m\u0013\tIeI\u0001\u0006T#2\u001buN\u001c;fqRDQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtDcA'R%R\u0019aj\u0014)\u0011\u0005\u0005\u0002\u0001\"\u0002\u001fK\u0001\bi\u0004\"B\"K\u0001\b!\u0005\"B\u0013K\u0001\u00049\u0003\"\u0002\u0019K\u0001\u0004\u0011\u0004\"B&\u0001\t\u0003!F#A+\u0015\u000793v\u000bC\u0003='\u0002\u000fQ\bC\u0003D'\u0002\u000fA\tC\u0003L\u0001\u0011\u0005\u0011\f\u0006\u0003O5nc\u0006\"\u0002\u0019Y\u0001\u0004\u0011\u0004\"\u0002\u001fY\u0001\u0004i\u0004\"B\"Y\u0001\u0004!\u0005\"\u00020\u0001\t\u0003z\u0016a\u00014jiR\u0011A\u0003\u0019\u0005\u0006Cv\u0003\rAY\u0001\bI\u0006$\u0018m]3ua\t\u0019\u0007\u000eE\u0002FI\u001aL!!\u001a$\u0003\u000f\u0011\u000bG/Y:fiB\u0011q\r\u001b\u0007\u0001\t%I\u0007-!A\u0001\u0002\u000b\u0005!NA\u0002`IE\n\"a\u001b8\u0011\u0005!b\u0017BA7*\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001K8\n\u0005AL#aA!os\")!\u000f\u0001C!g\u0006yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0002uuB\u0011Q\u000f_\u0007\u0002m*\u0011qOR\u0001\u0006if\u0004Xm]\u0005\u0003sZ\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015Y\u0018\u000f1\u0001u\u0003\u0019\u00198\r[3nC\"\u0012\u0011/ \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001\"\u0001\u0006b]:|G/\u0019;j_:L1!!\u0002\u0000\u00051!UM^3m_B,'/\u00119j\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY!A\u000bn_\u0012,GnU3mK\u000e$\u0018n\u001c8DY>\u001cXO]3\u0016\u0005\u00055\u0001\u0003\u0002\u0015,\u0003\u001f\u0001r\u0001KA\t\u0003+\tI&C\u0002\u0002\u0014%\u0012\u0011BR;oGRLwN\\\u00191\t\u0005]\u0011\u0011\u0006\t\u0007\u00033\t\u0019#a\n\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tAa\u001a:jI*\u0011\u0011\u0011E\u0001\u0004Q\u0016D\u0018\u0002BA\u0013\u00037\u0011Aa\u0012:jIB\u0019q-!\u000b\u0005\u0017\u0005-\u0012QFA\u0001\u0002\u0003\u0015\tA\u001b\u0002\u0004?\u0012\u0012\u0004\u0002CA\u0018\u0001\u0001\u0006K!!\r\u0002-5|G-\u001a7TK2,7\r^5p]\u000ecwn];sK\u0002\u0002B\u0001K\u0016\u00024A9\u0001&!\u0005\u00026\u0005u\u0002\u0007BA\u001c\u0003w\u0001b!!\u0007\u0002$\u0005e\u0002cA4\u0002<\u0011Y\u00111FA\u0017\u0003\u0003\u0005\tQ!\u0001ka!\ty$!\u0013\u0002P\u0005U\u0003CCA!\u0003\u0007\n9%!\u0014\u0002T5\u0011\u0011qD\u0005\u0005\u0003\u000b\nyBA\u0003N_\u0012,G\u000eE\u0002h\u0003\u0013\"1\"a\u0013\u0002.\u0005\u0005\t\u0011!B\u0001U\n\u0019q\fJ\u001a\u0011\u0007\u001d\fy\u0005B\u0006\u0002R\u00055\u0012\u0011!A\u0001\u0006\u0003Q'aA0%iA\u0019q-!\u0016\u0005\u0017\u0005]\u0013QFA\u0001\u0002\u0003\u0015\tA\u001b\u0002\u0004?\u0012*\u0004\u0007CA.\u0003?\n\u0019'a\u001a\u0011\u0015\u0005\u0005\u00131IA/\u0003C\n)\u0007E\u0002h\u0003?\"1\"a\u0013\u0002.\u0005\u0005\t\u0011!B\u0001UB\u0019q-a\u0019\u0005\u0017\u0005E\u0013QFA\u0001\u0002\u0003\u0015\tA\u001b\t\u0004O\u0006\u001dDaCA,\u0003[\t\t\u0011!A\u0003\u0002)D\u0011\"a\u001b\u0001\u0001\u0004%I!!\u001c\u000235|G-\u001a7TK2,7\r^5p]\u000ecwn];sK~#S-\u001d\u000b\u0005\u0003_\n)\bE\u0002)\u0003cJ1!a\u001d*\u0005\u0011)f.\u001b;\t\u0015\u0005]\u0014\u0011NA\u0001\u0002\u0004\tI(A\u0002yIE\u0002B\u0001K\u0016\u0002|A9\u0001&!\u0005\u0002~\u0005\u0015\u0005\u0007BA@\u0003\u0007\u0003b!!\u0007\u0002$\u0005\u0005\u0005cA4\u0002\u0004\u0012Y\u00111FA\u0017\u0003\u0003\u0005\tQ!\u0001ka!\t9)a#\u0002\u0010\u0006M\u0005CCA!\u0003\u0007\nI)!$\u0002\u0012B\u0019q-a#\u0005\u0017\u0005-\u0013QFA\u0001\u0002\u0003\u0015\tA\u001b\t\u0004O\u0006=EaCA)\u0003[\t\t\u0011!A\u0003\u0002)\u00042aZAJ\t-\t9&!\f\u0002\u0002\u0003\u0005)\u0011\u00016\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006A2/\u001a;N_\u0012,GnU3mK\u000e$\u0018n\u001c8DY>\u001cXO]3\u0015\t\u0005=\u00141\u0014\u0005\t\u0003;\u000b)\n1\u0001\u0002 \u0006\u00111\r\u001c\t\bQ\u0005E\u0011\u0011UAVa\u0011\t\u0019+a*\u0011\r\u0005e\u00111EAS!\r9\u0017q\u0015\u0003\f\u0003S\u000bY*!A\u0001\u0002\u000b\u0005!NA\u0002`IY\u0002\u0004\"!,\u00022\u0006]\u0016Q\u0018\t\u000b\u0003\u0003\n\u0019%a,\u00026\u0006m\u0006cA4\u00022\u0012Y\u00111WAN\u0003\u0003\u0005\tQ!\u0001k\u0005\ryFe\u000e\t\u0004O\u0006]FaCA]\u00037\u000b\t\u0011!A\u0003\u0002)\u00141a\u0018\u00139!\r9\u0017Q\u0018\u0003\f\u0003\u007f\u000bY*!A\u0001\u0002\u000b\u0005!NA\u0002`IeBq!a1\u0001\t\u0003\n)-\u0001\u0003d_BLH\u0003BAd\u0003\u0013l\u0011\u0001\u0001\u0005\t\u0003\u0017\f\t\r1\u0001\u0002N\u0006)Q\r\u001f;sCB!\u0011qZAk\u001b\t\t\tNC\u0002\u0002T\u001a\tQ\u0001]1sC6LA!a6\u0002R\nA\u0001+\u0019:b[6\u000b\u0007\u000fC\u0004\u0002\\\u0002!\t%!8\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005}\u0007cA\u000e\u0002b&\u0019\u00111\u001d\u000f\u0003\u00115cuK]5uKJDc!!7\u0002h\u00065\bc\u0001@\u0002j&\u0019\u00111^@\u0003\u000bMKgnY3\"\u0005\u0005=\u0018!B\u0019/m9\u0002\u0004BBAz\u0001\u0011\u0005\u0011'A\beK\u001a\fW\u000f\u001c;GS2,g*Y7f\u000f\u001d\t9P\u0001E\u0001\u0003s\fQ\u0002\u0013\u001aP\u000fJLGmU3be\u000eD\u0007cA\u0011\u0002|\u001a1\u0011A\u0001E\u0001\u0003{\u001c\u0002\"a?\u0002\u0000\n\u0015!1\u0002\t\u0004Q\t\u0005\u0011b\u0001B\u0002S\t1\u0011I\\=SK\u001a\u0004Ba\u0007B\u0004\u001d&\u0019!\u0011\u0002\u000f\u0003\u00155c%+Z1eC\ndW\rE\u0002)\u0005\u001bI1Aa\u0004*\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dY\u00151 C\u0001\u0005'!\"!!?\t\u0015\u0005M\u00181 b\u0001\n\u001b\u00119\"\u0006\u0002\u0003\u001a=\u0011!1D\u0011\u0003\u0005;\t\u0011c\u001a:jIN,\u0017M]2i?B\f'/Y7t\u0011%\u0011\t#a?!\u0002\u001b\u0011I\"\u0001\teK\u001a\fW\u000f\u001c;GS2,g*Y7fA!A!QEA~\t\u0003\u00129#\u0001\u0003sK\u0006$WC\u0001B\u0015!\u0011Y\"1\u0006(\n\u0007\t5BD\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0019\u0011\u0019#a:\u0002n\"A!1GA~\t\u0003\u0012)$\u0001\u0003m_\u0006$Gc\u0001(\u00038!9!\u0011\bB\u0019\u0001\u0004\u0011\u0014\u0001\u00029bi\"DcA!\r\u0002h\u00065\bB\u0003B \u0003w\f\t\u0011\"\u0003\u0003B\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0005\u0005\u0003\u0003F\t=SB\u0001B$\u0015\u0011\u0011IEa\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001b\nAA[1wC&!!\u0011\u000bB$\u0005\u0019y%M[3di\u0002")
public class H2OGridSearch
extends Estimator<H2OMOJOModel>
implements MLWritable,
H2OGridSearchParams {
    private final Option<H2OGridSearchParams> gridSearchParams;
    private final String uid;
    private final H2OContext hc;
    private Option<Function1<Grid<?>, Model<?, ?, ?>>> modelSelectionClosure;
    private final DoubleParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$ratio;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$algo;
    private final GBMParametersParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$parameters;
    private final HyperParamsParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$hyperParameters;
    private final NullableStringParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$predictionCol;
    private final BooleanParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$allStringColumnsToCategorical;
    private final StringArrayParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$columnsToCategorical;

    public static H2OGridSearch load(String string) {
        return H2OGridSearch$.MODULE$.load(string);
    }

    public static MLReader<H2OGridSearch> read() {
        return H2OGridSearch$.MODULE$.read();
    }

    @Override
    public final DoubleParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$ratio() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$ratio;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$algo() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$algo;
    }

    @Override
    public final GBMParametersParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$parameters() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$parameters;
    }

    @Override
    public final HyperParamsParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$hyperParameters() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$hyperParameters;
    }

    @Override
    public final NullableStringParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$predictionCol() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$predictionCol;
    }

    @Override
    public final BooleanParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$allStringColumnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$allStringColumnsToCategorical;
    }

    @Override
    public final StringArrayParam org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$columnsToCategorical() {
        return this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$columnsToCategorical;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$ratio_$eq(DoubleParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$ratio = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$algo_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$algo = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$parameters_$eq(GBMParametersParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$parameters = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$hyperParameters_$eq(HyperParamsParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$hyperParameters = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$predictionCol_$eq(NullableStringParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$predictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$allStringColumnsToCategorical_$eq(BooleanParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$allStringColumnsToCategorical = x$1;
    }

    @Override
    public final void org$apache$spark$ml$h2o$algos$H2OGridSearchParams$_setter_$org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$columnsToCategorical_$eq(StringArrayParam x$1) {
        this.org$apache$spark$ml$h2o$algos$H2OGridSearchParams$$columnsToCategorical = x$1;
    }

    @Override
    public double getRatio() {
        return H2OGridSearchParams$class.getRatio(this);
    }

    @Override
    public String getAlgo() {
        return H2OGridSearchParams$class.getAlgo(this);
    }

    @Override
    public GBMModel.GBMParameters getParameters() {
        return H2OGridSearchParams$class.getParameters(this);
    }

    @Override
    public scala.collection.immutable.Map<String, Object[]> getHyperParameters() {
        return H2OGridSearchParams$class.getHyperParameters(this);
    }

    @Override
    public String getPredictionsCol() {
        return H2OGridSearchParams$class.getPredictionsCol(this);
    }

    @Override
    public boolean getAllStringColumnsToCategorical() {
        return H2OGridSearchParams$class.getAllStringColumnsToCategorical(this);
    }

    @Override
    public String[] getColumnsToCategorical() {
        return H2OGridSearchParams$class.getColumnsToCategorical(this);
    }

    @Override
    public H2OGridSearchParams setRatio(double value) {
        return H2OGridSearchParams$class.setRatio(this, value);
    }

    @Override
    public H2OGridSearchParams setAlgo(String value) {
        return H2OGridSearchParams$class.setAlgo(this, value);
    }

    @Override
    public H2OGridSearchParams setParameters(GBMModel.GBMParameters value) {
        return H2OGridSearchParams$class.setParameters((H2OGridSearchParams)this, value);
    }

    @Override
    public H2OGridSearchParams setParameters(H2OGBM value) {
        return H2OGridSearchParams$class.setParameters((H2OGridSearchParams)this, value);
    }

    @Override
    public H2OGridSearchParams setHyperParameters(scala.collection.immutable.Map<String, Object[]> value) {
        return H2OGridSearchParams$class.setHyperParameters((H2OGridSearchParams)this, value);
    }

    @Override
    public H2OGridSearchParams setHyperParameters(scala.collection.mutable.Map<String, Object[]> value) {
        return H2OGridSearchParams$class.setHyperParameters((H2OGridSearchParams)this, value);
    }

    @Override
    public H2OGridSearchParams setPredictionsCol(String value) {
        return H2OGridSearchParams$class.setPredictionsCol(this, value);
    }

    @Override
    public H2OGridSearchParams setAllStringColumnsToCategorical(boolean value) {
        return H2OGridSearchParams$class.setAllStringColumnsToCategorical(this, value);
    }

    @Override
    public H2OGridSearchParams setColumnsToCategorical(String first, Seq<String> others) {
        return H2OGridSearchParams$class.setColumnsToCategorical(this, first, others);
    }

    @Override
    public H2OGridSearchParams setColumnsToCategorical(String[] columns) {
        return H2OGridSearchParams$class.setColumnsToCategorical(this, columns);
    }

    public void save(String path) throws IOException {
        MLWritable.class.save((MLWritable)this, (String)path);
    }

    public Option<H2OGridSearchParams> gridSearchParams() {
        return this.gridSearchParams;
    }

    public String uid() {
        return this.uid;
    }

    public H2OMOJOModel fit(Dataset<?> dataset) {
        GBMModel.GBMParameters params = (GBMModel.GBMParameters)this.gridSearchParams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GBMModel.GBMParameters apply(H2OGridSearchParams x$1) {
                return x$1.getParameters();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2OGridSearch $outer;

            public final GBMModel.GBMParameters apply() {
                return this.$outer.getParameters();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map hyperParams = (scala.collection.immutable.Map)this.gridSearchParams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Object[]> apply(H2OGridSearchParams x$2) {
                return x$2.getHyperParameters();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2OGridSearch $outer;

            public final scala.collection.immutable.Map<String, Object[]> apply() {
                return this.$outer.getHyperParameters();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        H2OFrame input = this.hc.asH2OFrame(dataset.toDF());
        if (this.getRatio() < 1.0) {
            Frame[] keys = H2OFrameSupport$.MODULE$.split((Frame)input, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Key.rand(), Key.rand()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.getRatio()})));
            params._train = keys[0]._key;
            if (keys.length > 1) {
                params._valid = keys[1]._key;
            }
        } else {
            params._train = input._key;
        }
        params._response_column = this.getPredictionsCol();
        Frame trainFrame = (Frame)params._train.get();
        Object object = this.getAllStringColumnsToCategorical() ? H2OFrameSupport$.MODULE$.allStringVecToCategorical(trainFrame) : BoxedUnit.UNIT;
        H2OFrameSupport$.MODULE$.columnsToCategorical(trainFrame, this.getColumnsToCategorical());
        DKV.put((Keyed)trainFrame);
        Job job = GridSearch.startGridSearch((Key)Key.make(), (Model.Parameters)params, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)hyperParams).asJava()));
        Grid grid = (Grid)job.get();
        if (grid.getModels().length == 0) {
            throw new IllegalArgumentException("No Model returned.");
        }
        Model modelFromGrid = this.modelSelectionClosure().isEmpty() ? grid.getModels()[0] : (Model)((Function1)this.modelSelectionClosure().get()).apply((Object)grid);
        H2OMOJOModel model = new H2OMOJOModel(ModelSerializationSupport$.MODULE$.getMojoData(modelFromGrid));
        model.setConvertUnknownCategoricalLevelsToNa(true);
        return model;
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        return schema;
    }

    private Option<Function1<Grid<?>, Model<?, ?, ?>>> modelSelectionClosure() {
        return this.modelSelectionClosure;
    }

    private void modelSelectionClosure_$eq(Option<Function1<Grid<?>, Model<?, ?, ?>>> x$1) {
        this.modelSelectionClosure = x$1;
    }

    public void setModelSelectionClosure(Function1<Grid<?>, Model<?, ?, ?>> cl) {
        this.modelSelectionClosure_$eq((Option<Function1<Grid<?>, Model<?, ?, ?>>>)new Some(cl));
    }

    public H2OGridSearch copy(ParamMap extra) {
        return (H2OGridSearch)this.defaultCopy(extra);
    }

    public MLWriter write() {
        return new H2OGridSearchWriter(this);
    }

    public String defaultFileName() {
        return "gridsearch_params";
    }

    public H2OGridSearch(Option<H2OGridSearchParams> gridSearchParams, String uid, H2OContext hc, SQLContext sqlContext) {
        this.gridSearchParams = gridSearchParams;
        this.uid = uid;
        this.hc = hc;
        MLWritable.class.$init$((MLWritable)this);
        H2OGridSearchParams$class.$init$(this);
        this.modelSelectionClosure = None$.MODULE$;
    }

    public H2OGridSearch(H2OContext hc, SQLContext sqlContext) {
        this((Option<H2OGridSearchParams>)None$.MODULE$, Identifiable$.MODULE$.randomUID("gridsearch"), hc, sqlContext);
    }

    public H2OGridSearch(String uid, H2OContext hc, SQLContext sqlContext) {
        this((Option<H2OGridSearchParams>)None$.MODULE$, uid, hc, sqlContext);
    }
}

