/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.algos;

import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.h2o.H2OContext$;
import org.apache.spark.ml.h2o.algos.H2OGridSearch;
import org.apache.spark.ml.h2o.algos.H2OGridSearchParams;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.MLReader;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2Q!\u0001\u0002\u0001\u00059\u00111\u0003\u0013\u001aP\u000fJLGmU3be\u000eD'+Z1eKJT!a\u0001\u0003\u0002\u000b\u0005dwm\\:\u000b\u0005\u00151\u0011a\u000153_*\u0011q\u0001C\u0001\u0003[2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0003\u0001=\u00012\u0001E\n\u0016\u001b\u0005\t\"B\u0001\n\u0007\u0003\u0011)H/\u001b7\n\u0005Q\t\"\u0001C'M%\u0016\fG-\u001a:\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!!\u0004%3\u001f\u001e\u0013\u0018\u000eZ*fCJ\u001c\u0007\u000e\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003=!WMZ1vYR4\u0015\u000e\\3OC6,7\u0001A\u000b\u0002;A\u0011a\u0004\n\b\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005I\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$A!A\u0001\u0006\u0001B\u0001B\u0003%Q$\u0001\teK\u001a\fW\u000f\u001c;GS2,g*Y7fA!)!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"\"\u0001L\u0017\u0011\u0005Y\u0001\u0001\"\u0002\u000e*\u0001\u0004i\u0002bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\nG2\f7o\u001d(b[\u0016,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nA\u0001\\1oO*\ta'\u0001\u0003kCZ\f\u0017BA\u00134\u0011\u0019I\u0004\u0001)A\u0005c\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\t\u000bm\u0002A\u0011\t\u001f\u0002\t1|\u0017\r\u001a\u000b\u0003+uBQA\u0010\u001eA\u0002u\tA\u0001]1uQ\u0002")
public class H2OGridSearchReader
extends MLReader<H2OGridSearch> {
    private final String defaultFileName;
    private final String className;

    public String defaultFileName() {
        return this.defaultFileName;
    }

    private String className() {
        return this.className;
    }

    public H2OGridSearch load(String path) {
        DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
        Path inputPath = new Path(path, this.defaultFileName());
        FileSystem fs = inputPath.getFileSystem(this.sc().hadoopConfiguration());
        Path qualifiedInputPath = inputPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        ObjectInputStream ois = new ObjectInputStream((InputStream)fs.open(qualifiedInputPath));
        H2OGridSearchParams gridSearchParams = (H2OGridSearchParams)ois.readObject();
        H2OContext h2oContext = H2OContext$.MODULE$.ensure((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "H2OContext has to be started in order to use H2O pipelines elements.";
            }
        });
        H2OGridSearch algo2 = new H2OGridSearch((Option<H2OGridSearchParams>)Option$.MODULE$.apply((Object)gridSearchParams), metadata.uid(), h2oContext, this.sqlContext());
        DefaultParamsReader$.MODULE$.getAndSetParams((Params)algo2, metadata, DefaultParamsReader$.MODULE$.getAndSetParams$default$3());
        return algo2;
    }

    public H2OGridSearchReader(String defaultFileName) {
        this.defaultFileName = defaultFileName;
        this.className = ((ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(H2OGridSearch.class))).runtimeClass().getName();
    }
}

