/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.h2o.param;

import hex.Model;
import hex.genmodel.utils.DistributionFamily;
import org.apache.spark.ml.h2o.param.H2OAlgoParams;
import org.apache.spark.ml.h2o.param.H2ODistributionParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class H2OAlgoParams$class {
    public static double getTrainRatio(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.ratio()));
    }

    public static String getPredictionsCol(H2OAlgoParams $this) {
        return (String)$this.$($this.predictionCol());
    }

    public static String[] getFeaturesCols(H2OAlgoParams $this) {
        String[] stringArray;
        if (Predef$.MODULE$.refArrayOps((Object[])$this.$((Param)$this.featuresCols())).contains($this.$($this.predictionCol()))) {
            $this.logDebug((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ H2OAlgoParams $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Prediction col '").append(this.$outer.$(this.$outer.predictionCol())).append((Object)"' removed from the list of features.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])$this.$((Param)$this.featuresCols())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ H2OAlgoParams $outer;

                public final boolean apply(String x$1) {
                    String string = x$1;
                    Object object = this.$outer.$(this.$outer.predictionCol());
                    return string != null ? !string.equals(object) : object != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            stringArray = (String[])$this.$((Param)$this.featuresCols());
        }
        return stringArray;
    }

    public static boolean getAllStringColumnsToCategorical(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.allStringColumnsToCategorical()));
    }

    public static String[] getColumnsToCategorical(H2OAlgoParams $this) {
        return (String[])$this.$((Param)$this.columnsToCategorical());
    }

    public static int getNfolds(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.nfolds()));
    }

    public static boolean getKeepCrossValidationPredictions(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.keepCrossValidationPredictions()));
    }

    public static boolean getKeepCrossValidationFoldAssignment(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.keepCrossValidationFoldAssignment()));
    }

    public static boolean getParallelizeCrossValidation(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.parallelizeCrossValidation()));
    }

    public static long getSeed(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToLong((Object)$this.$((Param)$this.seed()));
    }

    public static DistributionFamily getDistribution(H2OAlgoParams $this) {
        return (DistributionFamily)$this.$($this.distribution());
    }

    public static boolean getConvertUnknownCategoricalLevelsToNa(H2OAlgoParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.convertUnknownCategoricalLevelsToNa()));
    }

    public static H2OAlgoParams setTrainRatio(H2OAlgoParams $this, double value) {
        return (H2OAlgoParams)$this.set((Param)$this.ratio(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OAlgoParams setPredictionsCol(H2OAlgoParams $this, String value) {
        return (H2OAlgoParams)$this.set($this.predictionCol(), value);
    }

    public static H2OAlgoParams setFeaturesCols(H2OAlgoParams $this, String first, Seq others) {
        return (H2OAlgoParams)$this.set((Param)$this.featuresCols(), Predef$.MODULE$.refArrayOps((Object[])new String[]{first}).$plus$plus((GenTraversableOnce)others, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    public static H2OAlgoParams setFeaturesCols(H2OAlgoParams $this, String[] cols) {
        if (cols.length == 0) {
            throw new IllegalArgumentException("Array with feature columns must contain at least one column.");
        }
        return (H2OAlgoParams)$this.set((Param)$this.featuresCols(), cols);
    }

    public static H2OAlgoParams setFeaturesCol(H2OAlgoParams $this, String first) {
        return $this.setFeaturesCols(first, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public static H2OAlgoParams setAllStringColumnsToCategorical(H2OAlgoParams $this, boolean transform2) {
        return (H2OAlgoParams)$this.set((Param)$this.allStringColumnsToCategorical(), BoxesRunTime.boxToBoolean((boolean)transform2));
    }

    public static H2OAlgoParams setColumnsToCategorical(H2OAlgoParams $this, String first, Seq others) {
        return (H2OAlgoParams)$this.set((Param)$this.columnsToCategorical(), Predef$.MODULE$.refArrayOps((Object[])new String[]{first}).$plus$plus((GenTraversableOnce)others, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    public static H2OAlgoParams setColumnsToCategorical(H2OAlgoParams $this, String[] columns) {
        return (H2OAlgoParams)$this.set((Param)$this.columnsToCategorical(), columns);
    }

    public static H2OAlgoParams setNfolds(H2OAlgoParams $this, int value) {
        return (H2OAlgoParams)$this.set((Param)$this.nfolds(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OAlgoParams setKeepCrossValidationPredictions(H2OAlgoParams $this, boolean value) {
        return (H2OAlgoParams)$this.set((Param)$this.keepCrossValidationPredictions(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OAlgoParams setKeepCrossValidationFoldAssignment(H2OAlgoParams $this, boolean value) {
        return (H2OAlgoParams)$this.set((Param)$this.keepCrossValidationFoldAssignment(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OAlgoParams setParallelizeCrossValidation(H2OAlgoParams $this, boolean value) {
        return (H2OAlgoParams)$this.set((Param)$this.parallelizeCrossValidation(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2OAlgoParams setSeed(H2OAlgoParams $this, long value) {
        return (H2OAlgoParams)$this.set((Param)$this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public static H2OAlgoParams setDistribution(H2OAlgoParams $this, DistributionFamily value) {
        return (H2OAlgoParams)$this.set($this.distribution(), value);
    }

    public static H2OAlgoParams setConvertUnknownCategoricalLevelsToNa(H2OAlgoParams $this, boolean value) {
        return (H2OAlgoParams)$this.set((Param)$this.convertUnknownCategoricalLevelsToNa(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static H2ODistributionParam H2ODistributionParam(H2OAlgoParams $this, String name) {
        return new H2ODistributionParam($this, name, $this.getDoc((Option<String>)None$.MODULE$, name));
    }

    public static void updateH2OParams(H2OAlgoParams $this) {
        ((Model.Parameters)$this.parameters())._response_column = (String)$this.$($this.predictionCol());
        ((Model.Parameters)$this.parameters())._nfolds = BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.nfolds()));
        ((Model.Parameters)$this.parameters())._keep_cross_validation_predictions = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.keepCrossValidationPredictions()));
        ((Model.Parameters)$this.parameters())._keep_cross_validation_fold_assignment = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.keepCrossValidationFoldAssignment()));
        ((Model.Parameters)$this.parameters())._parallelize_cross_validation = BoxesRunTime.unboxToBoolean((Object)$this.$((Param)$this.parallelizeCrossValidation()));
        ((Model.Parameters)$this.parameters())._seed = BoxesRunTime.unboxToLong((Object)$this.$((Param)$this.seed()));
        ((Model.Parameters)$this.parameters())._distribution = (DistributionFamily)$this.$($this.distribution());
    }

    public static void $init$(H2OAlgoParams $this) {
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$ratio_$eq($this.doubleParam("ratio", "Determines in which ratios split the dataset"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$predictionCol_$eq($this.stringParam("predictionCol", "Prediction column name"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$featuresCols_$eq($this.stringArrayParam("featuresCols", "Name of feature columns"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$allStringColumnsToCategorical_$eq($this.booleanParam("allStringColumnsToCategorical", "Transform all strings columns to categorical"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$columnsToCategorical_$eq($this.stringArrayParam("columnsToCategorical", "List of columns to convert to categorical before modelling"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$nfolds_$eq($this.intParam("nfolds", $this.intParam$default$2()));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$keepCrossValidationPredictions_$eq($this.booleanParam("keepCrossValidationPredictions", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$keepCrossValidationFoldAssignment_$eq($this.booleanParam("keepCrossValidationFoldAssignment", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$parallelizeCrossValidation_$eq($this.booleanParam("parallelizeCrossValidation", $this.booleanParam$default$2()));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$seed_$eq($this.longParam("seed", $this.longParam$default$2()));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$distribution_$eq($this.H2ODistributionParam("distribution"));
        $this.org$apache$spark$ml$h2o$param$H2OAlgoParams$_setter_$convertUnknownCategoricalLevelsToNa_$eq($this.booleanParam("convertUnknownCategoricalLevelsToNa", "Convert unknown categorical levels to NA during predictions"));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.ratio().$minus$greater((Object)BoxesRunTime.boxToDouble((double)1.0)), $this.predictionCol().$minus$greater((Object)"prediction"), $this.featuresCols().$minus$greater(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), $this.nfolds().$minus$greater((Object)BoxesRunTime.boxToInteger((int)((Model.Parameters)$this.parameters())._nfolds)), $this.allStringColumnsToCategorical().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)true)), $this.columnsToCategorical().$minus$greater(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), $this.keepCrossValidationPredictions().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)((Model.Parameters)$this.parameters())._keep_cross_validation_predictions)), $this.keepCrossValidationFoldAssignment().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)((Model.Parameters)$this.parameters())._keep_cross_validation_fold_assignment)), $this.parallelizeCrossValidation().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)((Model.Parameters)$this.parameters())._parallelize_cross_validation)), $this.seed().$minus$greater((Object)BoxesRunTime.boxToLong((long)((Model.Parameters)$this.parameters())._seed)), $this.distribution().$minus$greater(((Model.Parameters)$this.parameters())._distribution), $this.convertUnknownCategoricalLevelsToNa().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false))}));
    }
}

