/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static void writeFile(Filer filer, Class<?> c, List<String> lines) {
        AnnotationUtils.writeFile(filer, c.getName(), lines);
    }

    public static void writeFile(Filer filer, String c, List<String> lines) {
        if (lines.isEmpty()) {
            return;
        }
        try {
            String outputFile = "META-INF/konduit-serving/" + c;
            FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", outputFile, new Element[0]);
            try (Writer w = file.openWriter();){
                w.write(String.join((CharSequence)"\n", lines));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error in annotation processing", t);
        }
    }

    public static boolean existsAndContains(Filer filer, String c, List<String> lines) {
        String outputFile = "META-INF/konduit-serving/" + c;
        if (!AnnotationUtils.fileExists(filer, c)) {
            return false;
        }
        String content = AnnotationUtils.getContent(filer, c);
        for (String s : lines) {
            if (content.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean fileExists(Filer filer, String c) {
        String outputFile = "META-INF/konduit-serving/" + c;
        try {
            FileObject file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", outputFile);
            return file != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getContent(Filer filer, String c) {
        String outputFile = "META-INF/konduit-serving/" + c;
        try {
            FileObject file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", outputFile);
            InputStream is = file.openInputStream();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                int ch = 0;
                while ((ch = ((Reader)r).read()) != -1) {
                    sb.append((char)ch);
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("ERROR READING FILE", e);
        }
    }
}

