/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.annotation.json;

import ai.konduit.serving.annotation.AnnotationUtils;
import ai.konduit.serving.annotation.json.JsonName;
import ai.konduit.serving.annotation.module.ModuleInfo;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"ai.konduit.serving.annotation.json.JsonName", "ai.konduit.serving.annotation.module.ModuleInfo"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class JsonNameProcessor
extends AbstractProcessor {
    private static final String PIPELINE_STEP = "ai.konduit.serving.pipeline.api.step.PipelineStep";
    private static final String SWITCH_FN = "ai.konduit.serving.pipeline.impl.pipeline.graph.SwitchFn";
    private static final String GRAPH_STEP = "ai.konduit.serving.pipeline.impl.pipeline.graph.GraphStep";
    private static final String TRIGGER = "ai.konduit.serving.pipeline.api.pipeline.Trigger";
    private List<String> toWrite = new ArrayList<String>();
    private List<JsonSubType> subTypes = new ArrayList<JsonSubType>();
    private String moduleName;
    private String moduleClass;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            this.writeFile();
        } else {
            Set<? extends Element> c;
            List<TypeElement> types;
            Iterator<TypeElement> iterator;
            if (this.moduleName == null && (iterator = (types = ElementFilter.typesIn(c = env.getElementsAnnotatedWith(ModuleInfo.class))).iterator()).hasNext()) {
                TypeElement te = iterator.next();
                this.moduleName = te.getAnnotation(ModuleInfo.class).value();
                this.moduleClass = te.toString();
            }
            c = env.getElementsAnnotatedWith(JsonName.class);
            types = ElementFilter.typesIn(c);
            for (TypeElement annotation : types) {
                TypeMirror t = annotation.asType();
                TypeMirror pipelineStepTypeMirror = this.processingEnv.getElementUtils().getTypeElement(PIPELINE_STEP).asType();
                TypeMirror switchFnTypeMirror = this.processingEnv.getElementUtils().getTypeElement(SWITCH_FN).asType();
                TypeMirror graphStepTypeMirror = this.processingEnv.getElementUtils().getTypeElement(GRAPH_STEP).asType();
                TypeMirror triggerMirror = this.processingEnv.getElementUtils().getTypeElement(TRIGGER).asType();
                boolean isPS = this.processingEnv.getTypeUtils().isAssignable(t, pipelineStepTypeMirror);
                boolean isSF = this.processingEnv.getTypeUtils().isAssignable(t, switchFnTypeMirror);
                boolean isGS = this.processingEnv.getTypeUtils().isAssignable(t, graphStepTypeMirror);
                boolean isT = this.processingEnv.getTypeUtils().isAssignable(t, triggerMirror);
                if (!isPS && !isSF && !isGS && !isT) continue;
                String str = isPS ? PIPELINE_STEP : (isSF ? SWITCH_FN : (isGS ? GRAPH_STEP : TRIGGER));
                String jn = annotation.getAnnotation(JsonName.class).value();
                this.toWrite.add(jn + "," + annotation.toString() + "," + str);
                this.subTypes.add(new JsonSubType(jn, annotation.toString(), str));
            }
        }
        return true;
    }

    protected void writeFile() {
        Throwable throwable;
        Writer w;
        String fullName;
        Filer filer = this.processingEnv.getFiler();
        if (filer == null) {
            System.err.println("No filer found. Returning.");
            return;
        }
        AnnotationUtils.writeFile(filer, JsonName.class, this.toWrite);
        String name = this.className();
        if (this.moduleClass == null) {
            return;
        }
        int idx = this.moduleClass.lastIndexOf(".");
        String pkg = null;
        if (idx > 0) {
            pkg = this.moduleClass.substring(0, idx);
            fullName = pkg + "." + name;
        } else {
            fullName = name;
        }
        StringBuilder sb = new StringBuilder();
        if (pkg != null) {
            sb.append("package ").append(pkg).append(";");
        }
        sb.append("import ai.konduit.serving.pipeline.api.serde.JsonSubType;\n").append("import ai.konduit.serving.pipeline.api.serde.JsonSubTypesMapping;\n").append("import ai.konduit.serving.pipeline.api.serde.JsonSubType;\n").append("\n").append("import java.util.ArrayList;\n").append("import java.util.List;\n");
        sb.append("//GENERATED CLASS DO NOT EDIT\n");
        sb.append("public class ").append(name).append(" implements JsonSubTypesMapping {").append("    @Override\n").append("    public List<JsonSubType> getSubTypesMapping() {\n").append("        List<JsonSubType> l = new ArrayList<>();\n");
        for (JsonSubType j : this.subTypes) {
            sb.append("        l.add(new JsonSubType(\"").append(j.name).append("\", ").append(j.className).append(".class, ").append(j.subtypeOf).append(".class").append("));\n");
        }
        sb.append("        \n").append("        return l;\n").append("    }\n").append("}");
        String s = sb.toString();
        try {
            JavaFileObject fo = filer.createSourceFile(fullName, new Element[0]);
            w = fo.openWriter();
            throwable = null;
            try {
                w.write(s);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            FileObject file2;
            try {
                file2 = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/ai.konduit.serving.pipeline.api.serde.JsonSubTypesMapping");
                file2.delete();
            }
            catch (IOException file2) {
                // empty catch block
            }
            file2 = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/ai.konduit.serving.pipeline.api.serde.JsonSubTypesMapping", new Element[0]);
            w = file2.openWriter();
            throwable = null;
            try {
                w.write(fullName);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing ");
        }
    }

    private String className() {
        if (this.moduleName == null) {
            return "";
        }
        String[] split = this.moduleName.split("-");
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1));
        }
        sb.append("JsonMapping");
        String s = sb.toString();
        return s;
    }

    private static class JsonSubType {
        private String name;
        private String className;
        private String subtypeOf;

        public JsonSubType(String name, String className, String subtypeOf) {
            this.name = name;
            this.className = className;
            this.subtypeOf = subtypeOf;
        }
    }
}

