/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.annotation.module;

import ai.konduit.serving.annotation.AnnotationUtils;
import ai.konduit.serving.annotation.module.Dependency;
import ai.konduit.serving.annotation.module.InheritRequiredDependencies;
import ai.konduit.serving.annotation.module.ModuleInfo;
import ai.konduit.serving.annotation.module.Req;
import ai.konduit.serving.annotation.module.Requires;
import ai.konduit.serving.annotation.module.RequiresDependenciesAll;
import ai.konduit.serving.annotation.module.RequiresDependenciesAny;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"ai.konduit.serving.annotation.module.ModuleInfo", "ai.konduit.serving.annotation.module.RequiresDependenciesAny", "ai.konduit.serving.annotation.module.RequiresDependenciesAll", "ai.konduit.serving.annotation.module.InheritRequiredDependencies"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class RequiresDependenciesProcessor
extends AbstractProcessor {
    public static final String INHERIT_MODULE_PREFIX = "inherit:";
    private String moduleName;
    private List<String> toWrite = new ArrayList<String>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            if (this.moduleName == null && !this.toWrite.isEmpty()) {
                if (AnnotationUtils.existsAndContains(this.processingEnv.getFiler(), "ai.konduit.serving.annotation.module.RequiresDependencies", this.toWrite)) {
                    return false;
                }
                Set<? extends Element> c = env.getElementsAnnotatedWith(RequiresDependenciesAll.class);
                List<TypeElement> types1 = ElementFilter.typesIn(c);
                Set<? extends Element> c2 = env.getElementsAnnotatedWith(RequiresDependenciesAny.class);
                List<TypeElement> types2 = ElementFilter.typesIn(c2);
                Set<? extends Element> c3 = env.getElementsAnnotatedWith(InheritRequiredDependencies.class);
                List<TypeElement> types3 = ElementFilter.typesIn(c3);
                throw new IllegalStateException("No class in this module is annotated with @ModuleInfo - a class with @ModuleInfo(\"your-module-name\") should be added to the module that has the @RequiresDependenciesAll or @RequiresDependenciesAny or @InheritRequiredDependencies annotation: " + types1 + ", " + types2 + ", " + types3);
            }
            this.writeFile();
        } else {
            Requires[] requires;
            Set<? extends Element> c;
            List<TypeElement> types;
            Iterator<TypeElement> iterator;
            if (this.moduleName == null && (iterator = (types = ElementFilter.typesIn(c = env.getElementsAnnotatedWith(ModuleInfo.class))).iterator()).hasNext()) {
                TypeElement te = iterator.next();
                this.moduleName = te.getAnnotation(ModuleInfo.class).value();
            }
            c = env.getElementsAnnotatedWith(RequiresDependenciesAll.class);
            List<TypeElement> l = ElementFilter.typesIn(c);
            for (TypeElement annotation : l) {
                for (Requires require : requires = annotation.getAnnotation(RequiresDependenciesAll.class).value()) {
                    Dependency[] deps = require.value();
                    Req req = require.requires();
                    ArrayList<String> depsStrList = new ArrayList<String>();
                    for (Dependency d : deps) {
                        String g = d.gId();
                        String a = d.aId();
                        String v = d.ver();
                        String[] cl = d.classifier();
                        Req r = d.cReq();
                        depsStrList.add(RequiresDependenciesProcessor.process(g, a, v, cl, r));
                    }
                    String s = req == Req.ALL ? "[" + String.join((CharSequence)",", depsStrList) + "]" : "{" + String.join((CharSequence)",", depsStrList) + "}";
                    this.toWrite.add(s);
                }
            }
            c = env.getElementsAnnotatedWith(RequiresDependenciesAny.class);
            l = ElementFilter.typesIn(c);
            for (TypeElement annotation : l) {
                requires = annotation.getAnnotation(RequiresDependenciesAny.class).value();
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                boolean first = true;
                for (Requires require : requires) {
                    if (!first) {
                        sb.append(",");
                    }
                    Dependency[] deps = require.value();
                    Req req = require.requires();
                    ArrayList<String> depsStrList = new ArrayList<String>();
                    for (Dependency d : deps) {
                        String g = d.gId();
                        String a = d.aId();
                        String v = d.ver();
                        String[] cl = d.classifier();
                        Req r = d.cReq();
                        depsStrList.add(RequiresDependenciesProcessor.process(g, a, v, cl, r));
                    }
                    String s = req == Req.ALL ? "[" + String.join((CharSequence)",", depsStrList) + "]" : "{" + String.join((CharSequence)",", depsStrList) + "}";
                    sb.append(s);
                    first = false;
                }
                sb.append("}");
                this.toWrite.add(sb.toString());
            }
            c = env.getElementsAnnotatedWith(InheritRequiredDependencies.class);
            l = ElementFilter.typesIn(c);
            for (TypeElement annotation : l) {
                String inheritFrom = annotation.getAnnotation(InheritRequiredDependencies.class).value();
                this.toWrite.add(INHERIT_MODULE_PREFIX + inheritFrom);
            }
        }
        return false;
    }

    private static String process(String g, String a, String v, String[] cl, Req r) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(g).append(":").append(a).append(":").append(v);
        if (cl != null && cl.length == 1) {
            sb.append(":").append(cl[0]);
        } else if (cl != null && cl.length > 1) {
            sb.append(":");
            if (r == Req.ALL) {
                sb.append("[").append(String.join((CharSequence)",", cl)).append("]");
            } else {
                sb.append("{").append(String.join((CharSequence)",", cl)).append("}");
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    protected void writeFile() {
        if (this.toWrite.isEmpty()) {
            this.toWrite.add("{}");
        }
        Filer filer = this.processingEnv.getFiler();
        ArrayList<String> toWrite2 = new ArrayList<String>();
        for (String s : this.toWrite) {
            toWrite2.add(this.moduleName + "," + s);
        }
        AnnotationUtils.writeFile(filer, "ai.konduit.serving.annotation.module.RequiresDependencies", toWrite2);
    }
}

