/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.annotation.runner;

import ai.konduit.serving.annotation.AnnotationUtils;
import ai.konduit.serving.annotation.module.ModuleInfo;
import ai.konduit.serving.annotation.runner.CanRun;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"ai.konduit.serving.annotation.runner.CanRun", "ai.konduit.serving.annotation.module.ModuleInfo"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class CanRunProcessor
extends AbstractProcessor {
    private List<String> toWrite = new ArrayList<String>();
    private String moduleName;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            if (this.moduleName == null && !this.toWrite.isEmpty()) {
                if (AnnotationUtils.existsAndContains(this.processingEnv.getFiler(), CanRun.class.getName(), this.toWrite)) {
                    return false;
                }
                Set<? extends Element> c = env.getElementsAnnotatedWith(CanRun.class);
                List<TypeElement> types = ElementFilter.typesIn(c);
                throw new IllegalStateException("No class in this module is annotated with @ModuleInfo - a class with @ModuleInfo(\"your-module-name\") should be added to the module that has the @CanRun(...) annotation: " + types + " - " + this.toWrite);
            }
            this.writeFile();
        } else {
            Set<? extends Element> c;
            List<TypeElement> types;
            Iterator<TypeElement> iterator;
            if (this.moduleName == null && (iterator = (types = ElementFilter.typesIn(c = env.getElementsAnnotatedWith(ModuleInfo.class))).iterator()).hasNext()) {
                TypeElement te = iterator.next();
                this.moduleName = te.getAnnotation(ModuleInfo.class).value();
            }
            c = env.getElementsAnnotatedWith(CanRun.class);
            types = ElementFilter.typesIn(c);
            TypeElement canRunElement = this.processingEnv.getElementUtils().getTypeElement(CanRun.class.getName());
            TypeMirror canRunType = canRunElement.asType();
            for (TypeElement annotation : types) {
                List<? extends AnnotationMirror> l = annotation.getAnnotationMirrors();
                String[] values = null;
                block1: for (AnnotationMirror annotationMirror : l) {
                    if (!annotationMirror.getAnnotationType().equals(canRunType)) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                        String s = entry.getValue().toString();
                        s = s.replace("{", "").replace("}", "");
                        values = s.split(", ?");
                        for (int i = 0; i < values.length; ++i) {
                            if (!values[i].endsWith(".class")) continue;
                            values[i] = values[i].substring(0, values[i].length() - 6);
                        }
                        continue block1;
                    }
                }
                if (values == null) continue;
                for (Iterator<? extends AnnotationMirror> iterator2 : values) {
                    this.toWrite.add(iterator2 + "," + annotation.toString());
                }
            }
        }
        return false;
    }

    protected void writeFile() {
        if (this.toWrite.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        ArrayList<String> toWrite2 = new ArrayList<String>();
        for (String s : this.toWrite) {
            toWrite2.add(s + "," + this.moduleName);
        }
        AnnotationUtils.writeFile(filer, CanRun.class, toWrite2);
    }
}

