/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonPropertyOrder(alphabetic=true)
public class ComponentInstance
implements IComponentInstance,
Serializable {
    private static final long serialVersionUID = 714378153827839502L;
    private final IComponent component;
    private final Map<String, String> parameterValues;
    private final Map<String, List<IComponentInstance>> satisfactionOfRequiredInterfaces;
    private final Map<String, String> annotations = new HashMap<String, String>();

    private ComponentInstance() {
        this.component = null;
        this.parameterValues = null;
        this.satisfactionOfRequiredInterfaces = null;
    }

    public ComponentInstance(ComponentInstance other) {
        this.component = other.component;
        this.parameterValues = new HashMap<String, String>(other.parameterValues);
        this.satisfactionOfRequiredInterfaces = new HashMap<String, List<IComponentInstance>>();
        other.satisfactionOfRequiredInterfaces.entrySet().forEach(x -> this.satisfactionOfRequiredInterfaces.put((String)x.getKey(), new ArrayList()));
        other.satisfactionOfRequiredInterfaces.entrySet().forEach(x -> ((List)x.getValue()).forEach(ci -> this.satisfactionOfRequiredInterfaces.get(x.getKey()).add(new ComponentInstance((ComponentInstance)ci))));
        other.annotations.entrySet().forEach(x -> this.annotations.put((String)x.getKey(), (String)x.getValue()));
    }

    public ComponentInstance(@JsonProperty(value="component") IComponent component, @JsonProperty(value="parameterValues") Map<String, String> parameterValues, @JsonProperty(value="satisfactionOfRequiredInterfaces") Map<String, List<IComponentInstance>> satisfactionOfRequiredInterfaces) {
        this.component = component;
        this.parameterValues = parameterValues;
        this.satisfactionOfRequiredInterfaces = satisfactionOfRequiredInterfaces;
    }

    @Override
    public IComponent getComponent() {
        return this.component;
    }

    @Override
    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public Collection<IParameter> getParametersThatHaveBeenSetExplicitly() {
        if (this.parameterValues == null) {
            return new ArrayList<IParameter>();
        }
        return this.getComponent().getParameters().stream().filter(p -> this.parameterValues.containsKey(p.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<IParameter> getParametersThatHaveNotBeenSetExplicitly() {
        return SetUtil.difference(this.component.getParameters(), this.getParametersThatHaveBeenSetExplicitly());
    }

    @Override
    public String getParameterValue(IParameter param) {
        return this.getParameterValue(param.getName());
    }

    @Override
    public String getParameterValue(String paramName) {
        return this.parameterValues.get(paramName);
    }

    @Override
    public Map<String, List<IComponentInstance>> getSatisfactionOfRequiredInterfaces() {
        return this.satisfactionOfRequiredInterfaces;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.satisfactionOfRequiredInterfaces == null ? 0 : this.satisfactionOfRequiredInterfaces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInstance other = (ComponentInstance)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        return !(this.satisfactionOfRequiredInterfaces == null ? other.satisfactionOfRequiredInterfaces != null : !this.satisfactionOfRequiredInterfaces.equals(other.satisfactionOfRequiredInterfaces));
    }

    public String toComponentNameString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getComponent().getName());
        if (!this.satisfactionOfRequiredInterfaces.isEmpty()) {
            sb.append(this.satisfactionOfRequiredInterfaces.entrySet().stream().map(x -> ((List)x.getValue()).stream().map(ci -> ((ComponentInstance)ci).toComponentNameString()).collect(Collectors.joining())).collect(Collectors.toList()).toString());
        }
        return sb.toString();
    }

    @JsonIgnore
    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("component", this.component);
        fields.put("parameterValues", this.parameterValues);
        fields.put("satisfactionOfRequiredInterfaces", this.satisfactionOfRequiredInterfaces);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    @JsonIgnore
    public String getPrettyPrint() throws IOException {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)this);
    }

    public String getNestedComponentDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getComponent().getName());
        this.satisfactionOfRequiredInterfaces.values().stream().map(x -> " - " + x.stream().map(ci -> ((ComponentInstance)ci).getNestedComponentDescription()).collect(Collectors.joining())).forEach(sb::append);
        return sb.toString();
    }

    public void putAnnotation(String key, String annotation) {
        this.annotations.put(key, annotation);
    }

    public String getAnnotation(String key) {
        return this.annotations.get(key);
    }

    public void appendAnnotation(String key, String annotation) {
        if (this.annotations.containsKey(key)) {
            this.annotations.put(key, this.annotations.get(key) + annotation);
        } else {
            this.annotations.put(key, annotation);
        }
    }

    @Override
    public List<IComponentInstance> getSatisfactionOfRequiredInterface(String idOfRequiredInterface) {
        if (!this.component.hasRequiredInterfaceWithId(idOfRequiredInterface)) {
            throw new IllegalArgumentException("\"" + idOfRequiredInterface + "\" is not a valid required interface id of component " + this.component.getName() + ". Valid ids are: " + this.component.getRequiredInterfaces().stream().map(ri -> "\n\t- " + ri.getId()).collect(Collectors.joining()));
        }
        return this.satisfactionOfRequiredInterfaces.get(idOfRequiredInterface);
    }
}

