/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.api.IParameterDependency;
import ai.libs.jaicore.components.api.IParameterDomain;
import ai.libs.jaicore.components.api.IRequiredInterfaceDefinition;
import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.ComponentUtil;
import ai.libs.jaicore.components.model.CompositionProblemUtil;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.serialization.ComponentSerialization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInstanceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ComponentInstanceUtil.class);

    private ComponentInstanceUtil() {
    }

    public static boolean isValidComponentInstantiation(ComponentInstance ci) {
        try {
            ComponentInstanceUtil.checkComponentInstantiation(ci);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkComponentInstantiation(ComponentInstance ci) {
        HashMap<IParameter, IParameterDomain> refinedDomainMap = new HashMap<IParameter, IParameterDomain>();
        for (IParameter param : ci.getComponent().getParameters()) {
            if (param.getDefaultDomain() instanceof NumericParameterDomain) {
                double parameterValue = Double.parseDouble(ci.getParameterValue(param));
                refinedDomainMap.put(param, new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), parameterValue, parameterValue));
                continue;
            }
            if (!(param.getDefaultDomain() instanceof CategoricalParameterDomain)) continue;
            refinedDomainMap.put(param, new CategoricalParameterDomain(Arrays.asList(ci.getParameterValue(param))));
        }
        for (IParameterDependency dependency : ci.getComponent().getParameterDependencies()) {
            if (!CompositionProblemUtil.isDependencyPremiseSatisfied(dependency, refinedDomainMap) || CompositionProblemUtil.isDependencyConditionSatisfied(dependency.getConclusion(), refinedDomainMap)) continue;
            throw new IllegalStateException("The dependency " + dependency + " of component " + ci.getComponent().getName() + " in the following component instance is violated: " + new ComponentSerialization().serialize(ci));
        }
    }

    public static String toComponentNameString(IComponentInstance ci) {
        StringBuilder sb = new StringBuilder();
        sb.append(ci.getComponent().getName());
        if (!ci.getSatisfactionOfRequiredInterfaces().isEmpty()) {
            sb.append("(").append(ci.getSatisfactionOfRequiredInterfaces().values().stream().map(ciList -> ciList.stream().map(cil -> ((ComponentInstance)cil).toComponentNameString()).collect(Collectors.joining())).collect(Collectors.joining(", "))).append(")");
        }
        return sb.toString();
    }

    public static ComponentInstance getDefaultParametrization(IComponentInstance ci) {
        HashMap<String, List<IComponentInstance>> defaultRequiredInterfaces = new HashMap<String, List<IComponentInstance>>();
        ci.getSatisfactionOfRequiredInterfaces().forEach((name, ciReqList) -> {
            List l = ciReqList.stream().map(ComponentInstanceUtil::getDefaultParametrization).collect(Collectors.toList());
            defaultRequiredInterfaces.put((String)name, l);
        });
        return new ComponentInstance(ci.getComponent(), new HashMap<String, String>(), defaultRequiredInterfaces);
    }

    public static boolean isDefaultConfiguration(IComponentInstance instance) {
        for (IParameter iParameter : instance.getParametersThatHaveBeenSetExplicitly()) {
            if (iParameter.isNumeric()) {
                double defaultValue = Double.parseDouble(iParameter.getDefaultValue().toString());
                String parameterValue = instance.getParameterValue(iParameter);
                boolean isCompatibleWithDefaultValue = false;
                if (parameterValue.contains("[")) {
                    List intervalAsList = SetUtil.unserializeList((String)instance.getParameterValue(iParameter));
                    isCompatibleWithDefaultValue = defaultValue >= Double.parseDouble((String)intervalAsList.get(0)) && defaultValue <= Double.parseDouble((String)intervalAsList.get(1));
                } else {
                    boolean bl = isCompatibleWithDefaultValue = Math.abs(defaultValue - Double.parseDouble(parameterValue)) < 1.0E-8;
                }
                if (!isCompatibleWithDefaultValue) {
                    logger.info("{} has value {}, which does not subsume the default value {}", new Object[]{iParameter.getName(), instance.getParameterValue(iParameter), defaultValue});
                    return false;
                }
                logger.info("{} has value {}, which IS COMPATIBLE with the default value {}", new Object[]{iParameter.getName(), instance.getParameterValue(iParameter), defaultValue});
                continue;
            }
            if (instance.getParameterValue(iParameter).equals(iParameter.getDefaultValue().toString())) continue;
            logger.info("{} has value {}, which is not the default {}", new Object[]{iParameter.getName(), instance.getParameterValue(iParameter), iParameter.getDefaultValue()});
            return false;
        }
        for (Collection collection : instance.getSatisfactionOfRequiredInterfaces().values()) {
            for (IComponentInstance child : collection) {
                if (ComponentInstanceUtil.isDefaultConfiguration(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static ComponentInstance sampleRandomComponentInstance(String requiredInterface, Collection<IComponent> components, Random rand) {
        ArrayList<IComponent> componentsList = new ArrayList<IComponent>(ComponentUtil.getComponentsProvidingInterface(components, requiredInterface));
        ComponentInstance ci = ComponentUtil.getRandomParameterizationOfComponent((IComponent)componentsList.get(rand.nextInt(componentsList.size())), rand);
        for (IRequiredInterfaceDefinition i : ci.getComponent().getRequiredInterfaces()) {
            ci.getSatisfactionOfRequiredInterfaces().put(i.getId(), Arrays.asList(ComponentInstanceUtil.sampleRandomComponentInstance(i.getName(), components, rand)));
        }
        return ci;
    }

    public static ComponentInstance sampleDefaultComponentInstance(String requiredInterface, Collection<? extends IComponent> components, Random rand) {
        ArrayList<IComponent> componentsList = new ArrayList<IComponent>(ComponentUtil.getComponentsProvidingInterface(components, requiredInterface));
        ComponentInstance ci = ComponentUtil.getDefaultParameterizationOfComponent((IComponent)componentsList.get(rand.nextInt(componentsList.size())));
        for (IRequiredInterfaceDefinition i : ci.getComponent().getRequiredInterfaces()) {
            ci.getSatisfactionOfRequiredInterfaces().put(i.getId(), Arrays.asList(ComponentInstanceUtil.sampleDefaultComponentInstance(i.getName(), components, rand)));
        }
        return ci;
    }

    public static boolean matchesPathRestrictions(ComponentInstance ci, Collection<List<Pair<String, String>>> paths) {
        for (List<Pair<String, String>> path : paths) {
            if (ComponentInstanceUtil.matchesPathRestriction(ci, path)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesPathRestriction(ComponentInstance ci, List<Pair<String, String>> path) {
        if (path.isEmpty()) {
            return true;
        }
        int i = 0;
        if (path.get(0).getX() == null) {
            String requiredComponent = (String)path.get(0).getY();
            if (!requiredComponent.equals("*") && !ci.getComponent().getName().equals(requiredComponent)) {
                return false;
            }
            i = 1;
        }
        IComponentInstance current = ci;
        int n = path.size();
        while (i < n) {
            Pair<String, String> selection = path.get(i);
            if (current.getComponent().getRequiredInterfaces().stream().noneMatch(ri -> ri.getId().equals(selection.getX()))) {
                throw new IllegalArgumentException("Invalid path restriction " + path + ": " + (String)selection.getX() + " is not a required interface of " + current.getComponent().getName());
            }
            Collection instancesChosenForRequiredInterface = current.getSatisfactionOfRequiredInterfaces().get(selection.getX());
            for (IComponentInstance instanceChosenForRequiredInterface : instancesChosenForRequiredInterface) {
                if (!((String)selection.getY()).equals("*") && !instanceChosenForRequiredInterface.getComponent().getName().equals(selection.getY())) {
                    return false;
                }
                current = instanceChosenForRequiredInterface;
            }
            ++i;
        }
        return true;
    }

    public static Collection<IComponent> getContainedComponents(IComponentInstance ci) {
        HashSet<IComponent> components = new HashSet<IComponent>();
        components.add(ci.getComponent());
        for (Collection collection : ci.getSatisfactionOfRequiredInterfaces().values()) {
            for (IComponentInstance ciSub : collection) {
                components.addAll(ComponentInstanceUtil.getContainedComponents(ciSub));
            }
        }
        return components;
    }

    public static String getComponentInstanceAsComponentNames(IComponentInstance instance) {
        StringBuilder sb = new StringBuilder();
        sb.append(instance.getComponent().getName());
        if (!instance.getSatisfactionOfRequiredInterfaces().isEmpty()) {
            sb.append("{").append(instance.getSatisfactionOfRequiredInterfaces().values().stream().map(ciList -> ciList.stream().map(ComponentInstanceUtil::getComponentInstanceAsComponentNames).collect(Collectors.joining())).collect(Collectors.joining(","))).append("}");
        }
        return sb.toString();
    }

    public static boolean isSubInstance(IComponentInstance sub, IComponentInstance sup) {
        if (!sub.getComponent().getName().equals(sup.getComponent().getName())) {
            return false;
        }
        Map<String, String> parametersOfSub = sub.getParameterValues();
        Map<String, String> parametersOfSup = sup.getParameterValues();
        for (Map.Entry<String, String> entry : parametersOfSub.entrySet()) {
            if (parametersOfSup.containsKey(entry.getKey()) && parametersOfSup.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<String, Object> entry : sub.getSatisfactionOfRequiredInterfaces().entrySet()) {
            int n = ((List)entry.getValue()).size();
            List<IComponentInstance> provisionsOfSup = sup.getSatisfactionOfRequiredInterface(entry.getKey());
            if (provisionsOfSup.size() < n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (ComponentInstanceUtil.isSubInstance((IComponentInstance)((List)entry.getValue()).get(i), provisionsOfSup.get(i))) continue;
                return false;
            }
        }
        return true;
    }
}

