/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstanceConstraint;
import ai.libs.jaicore.components.api.IComponentRepository;
import ai.libs.jaicore.components.model.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ComponentRepository
extends ArrayList<IComponent>
implements IComponentRepository {
    private static final long serialVersionUID = 3966345495009688845L;
    private final Collection<IComponentInstanceConstraint> constraints = new ArrayList<IComponentInstanceConstraint>();

    public ComponentRepository() {
        this(new ArrayList());
    }

    public ComponentRepository(Collection<? extends IComponent> components) {
        this(components, new ArrayList());
    }

    public ComponentRepository(Collection<? extends IComponent> components, Collection<? extends IComponentInstanceConstraint> constraints) {
        this.addAll(components);
        this.constraints.addAll(constraints);
    }

    @Override
    public Component getComponent(String name) {
        Optional<IComponent> opt = this.stream().filter(c -> c.getName().equals(name)).findAny();
        if (!opt.isPresent()) {
            throw new NoSuchElementException();
        }
        return (Component)opt.get();
    }

    @Override
    public Collection<IComponentInstanceConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.constraints.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentRepository other = (ComponentRepository)obj;
        return this.constraints.equals(other.constraints);
    }
}

