/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.api.IRequiredInterfaceDefinition;
import ai.libs.jaicore.components.exceptions.ComponentNotFoundException;
import ai.libs.jaicore.components.model.BooleanParameterDomain;
import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstanceUtil;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class ComponentUtil {
    private ComponentUtil() {
    }

    public static ComponentInstance getDefaultParameterizationOfComponent(IComponent component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (IParameter p : component.getParameters()) {
            parameterValues.put(p.getName(), p.getDefaultValue() + "");
        }
        return ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues);
    }

    public static ComponentInstance getRandomParameterizationOfComponent(IComponent component, Random rand) {
        HashMap<String, String> parameterValues;
        ComponentInstance ci;
        do {
            parameterValues = new HashMap<String, String>();
            for (IParameter p : component.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    String[] values = ((CategoricalParameterDomain)p.getDefaultDomain()).getValues();
                    parameterValues.put(p.getName(), values[rand.nextInt(values.length)]);
                    continue;
                }
                NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
                if (numDomain.isInteger()) {
                    if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                        parameterValues.put(p.getName(), (int)((double)rand.nextInt((int)(numDomain.getMax() - numDomain.getMin())) + numDomain.getMin()) + "");
                        continue;
                    }
                    if (p.getDefaultValue() instanceof Double) {
                        parameterValues.put(p.getName(), (int)((Double)p.getDefaultValue()).doubleValue() + "");
                        continue;
                    }
                    parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                    continue;
                }
                parameterValues.put(p.getName(), rand.nextDouble() * (numDomain.getMax() - numDomain.getMin()) + numDomain.getMin() + "");
            }
        } while (!ComponentInstanceUtil.isValidComponentInstantiation(ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues)));
        return ci;
    }

    public static ComponentInstance minParameterizationOfComponent(IComponent component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (IParameter p : component.getParameters()) {
            if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                parameterValues.put(p.getName(), p.getDefaultValue() + "");
                continue;
            }
            NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
            if (numDomain.isInteger()) {
                if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                    parameterValues.put(p.getName(), (int)numDomain.getMin() + "");
                    continue;
                }
                parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                continue;
            }
            parameterValues.put(p.getName(), numDomain.getMin() + "");
        }
        ComponentInstance ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues);
        ComponentInstanceUtil.checkComponentInstantiation(ci);
        return ci;
    }

    public static ComponentInstance maxParameterizationOfComponent(IComponent component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (IParameter p : component.getParameters()) {
            if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                parameterValues.put(p.getName(), p.getDefaultValue() + "");
                continue;
            }
            NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
            if (numDomain.isInteger()) {
                if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                    parameterValues.put(p.getName(), (int)numDomain.getMax() + "");
                    continue;
                }
                parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                continue;
            }
            parameterValues.put(p.getName(), numDomain.getMax() + "");
        }
        ComponentInstance ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues);
        ComponentInstanceUtil.checkComponentInstantiation(ci);
        return ci;
    }

    private static ComponentInstance componentInstanceWithNoRequiredInterfaces(IComponent component, Map<String, String> parameterValues) {
        return new ComponentInstance(component, parameterValues, new HashMap<String, List<IComponentInstance>>());
    }

    public static List<ComponentInstance> categoricalParameterizationsOfComponent(IComponent component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        ArrayList<ComponentInstance> parameterizedInstances = new ArrayList<ComponentInstance>();
        ArrayList<IParameter> categoricalParameters = new ArrayList<IParameter>();
        int maxParameterIndex = 0;
        for (IParameter p : component.getParameters()) {
            if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                String[] values = ((CategoricalParameterDomain)p.getDefaultDomain()).getValues();
                if (values.length > maxParameterIndex) {
                    maxParameterIndex = values.length;
                }
                categoricalParameters.add(p);
                continue;
            }
            parameterValues.put(p.getName(), p.getDefaultValue() + "");
        }
        for (int parameterIndex = 0; parameterIndex < maxParameterIndex; ++parameterIndex) {
            HashMap<String, String> categoricalParameterValues = new HashMap<String, String>();
            for (int i = 0; i < categoricalParameters.size(); ++i) {
                String parameterValue = null;
                String[] values = ((CategoricalParameterDomain)((IParameter)categoricalParameters.get(i)).getDefaultDomain()).getValues();
                parameterValue = parameterIndex < values.length ? values[parameterIndex] : ((IParameter)categoricalParameters.get(i)).getDefaultValue() + "";
                categoricalParameterValues.put(((IParameter)categoricalParameters.get(i)).getName(), parameterValue);
            }
            categoricalParameterValues.putAll(parameterValues);
            parameterizedInstances.add(new ComponentInstance(component, categoricalParameterValues, new HashMap<String, List<IComponentInstance>>()));
        }
        return parameterizedInstances;
    }

    public static Collection<IComponent> getComponentsProvidingInterface(Collection<? extends IComponent> components, String providedInterface) {
        return components.stream().filter(x -> x.getProvidedInterfaces().contains(providedInterface)).collect(Collectors.toList());
    }

    public static Collection<ComponentInstance> getAllAlgorithmSelectionInstances(IComponent rootComponent, Collection<? extends IComponent> components) {
        LinkedList<ComponentInstance> instanceList = new LinkedList<ComponentInstance>();
        instanceList.add(ComponentUtil.getDefaultParameterizationOfComponent(rootComponent));
        for (IRequiredInterfaceDefinition requiredInterface : rootComponent.getRequiredInterfaces()) {
            LinkedList<ComponentInstance> tempList = new LinkedList<ComponentInstance>();
            Collection<IComponent> possiblePlugins = ComponentUtil.getComponentsProvidingInterface(components, requiredInterface.getName());
            for (ComponentInstance ci : instanceList) {
                for (IComponent possiblePlugin : possiblePlugins) {
                    for (ComponentInstance reqICI : ComponentUtil.getAllAlgorithmSelectionInstances(possiblePlugin, components)) {
                        ComponentInstance copyOfCI = new ComponentInstance(ci.getComponent(), new HashMap<String, String>(ci.getParameterValues()), new HashMap<String, List<IComponentInstance>>(ci.getSatisfactionOfRequiredInterfaces()));
                        copyOfCI.getSatisfactionOfRequiredInterfaces().put(requiredInterface.getId(), Arrays.asList(reqICI));
                        tempList.add(copyOfCI);
                    }
                }
            }
            instanceList.clear();
            instanceList.addAll(tempList);
        }
        return instanceList;
    }

    public static Collection<ComponentInstance> getAllAlgorithmSelectionInstances(String requiredInterface, Collection<? extends IComponent> components) {
        ArrayList<ComponentInstance> instanceList = new ArrayList<ComponentInstance>();
        components.stream().filter(x -> x.getProvidedInterfaces().contains(requiredInterface)).map(x -> ComponentUtil.getAllAlgorithmSelectionInstances(x, components)).forEach(instanceList::addAll);
        return instanceList;
    }

    public static int getNumberOfUnparametrizedCompositions(Collection<? extends IComponent> components, String requiredInterface) {
        if (ComponentUtil.hasCycles(components, requiredInterface)) {
            return -1;
        }
        Collection candidates = components.stream().filter(c -> c.getProvidedInterfaces().contains(requiredInterface)).collect(Collectors.toList());
        int numCandidates = 0;
        for (IComponent candidate : candidates) {
            int waysToResolveComponent = 0;
            if (candidate.getRequiredInterfaces().isEmpty()) {
                waysToResolveComponent = 1;
            } else {
                for (IRequiredInterfaceDefinition reqIFaceDef : candidate.getRequiredInterfaces()) {
                    String reqIFace = reqIFaceDef.getName();
                    int numberOfSolutionPerSlotForThisInterface = ComponentUtil.getNumberOfUnparametrizedCompositions(components, reqIFace);
                    int subSolutionsForThisInterface = 0;
                    if (reqIFaceDef.isOptional() || reqIFaceDef.getMin() == 0) {
                        ++subSolutionsForThisInterface;
                    }
                    for (int i = Math.max(1, reqIFaceDef.getMin()); i <= reqIFaceDef.getMax(); ++i) {
                        int numberOfPossibleRealizationsForThisFixedNumberOfSlots = 1;
                        int numCandidatesForNextSlot = numberOfSolutionPerSlotForThisInterface;
                        for (int j = 0; j < i; ++j) {
                            numberOfPossibleRealizationsForThisFixedNumberOfSlots *= numCandidatesForNextSlot;
                            if (!reqIFaceDef.isUniqueComponents()) continue;
                            --numCandidatesForNextSlot;
                        }
                        subSolutionsForThisInterface += numberOfPossibleRealizationsForThisFixedNumberOfSlots;
                    }
                    if (waysToResolveComponent > 0) {
                        waysToResolveComponent *= subSolutionsForThisInterface;
                        continue;
                    }
                    waysToResolveComponent = subSolutionsForThisInterface;
                }
            }
            numCandidates += waysToResolveComponent;
        }
        return numCandidates;
    }

    public static ComponentInstance getRandomParametrization(IComponentInstance componentInstance, Random rand) {
        ComponentInstance randomParametrization = ComponentUtil.getRandomParameterizationOfComponent(componentInstance.getComponent(), rand);
        componentInstance.getSatisfactionOfRequiredInterfaces().entrySet().forEach(x -> randomParametrization.getSatisfactionOfRequiredInterfaces().put((String)x.getKey(), Arrays.asList(ComponentUtil.getRandomParametrization((IComponentInstance)((List)x.getValue()).iterator().next(), rand))));
        return randomParametrization;
    }

    public static boolean hasCycles(Collection<? extends IComponent> components, String requiredInterface) {
        return ComponentUtil.hasCycles(components, requiredInterface, new LinkedList<String>());
    }

    private static boolean hasCycles(Collection<? extends IComponent> components, String requiredInterface, List<String> componentList) {
        Collection candidates = components.stream().filter(c -> c.getProvidedInterfaces().contains(requiredInterface)).collect(Collectors.toList());
        for (IComponent c2 : candidates) {
            if (componentList.contains(c2.getName())) {
                return true;
            }
            LinkedList<String> componentListCopy = new LinkedList<String>(componentList);
            componentListCopy.add(c2.getName());
            for (IRequiredInterfaceDefinition subRequiredInterface : c2.getRequiredInterfaces()) {
                if (!ComponentUtil.hasCycles(components, subRequiredInterface.getName(), componentListCopy)) continue;
                return true;
            }
        }
        return false;
    }

    public static KVStore getStatsForComponents(Collection<Component> components) {
        KVStore stats = new KVStore();
        int numComponents = 0;
        int numNumericParams = 0;
        int numIntParams = 0;
        int numDoubleParams = 0;
        int numCatParams = 0;
        int numBoolParams = 0;
        int otherParams = 0;
        for (Component c : components) {
            ++numComponents;
            for (IParameter p : c.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    ++numCatParams;
                    if (!(p.getDefaultDomain() instanceof BooleanParameterDomain)) continue;
                    ++numBoolParams;
                    continue;
                }
                if (p.getDefaultDomain() instanceof NumericParameterDomain) {
                    ++numNumericParams;
                    if (((NumericParameterDomain)p.getDefaultDomain()).isInteger()) {
                        ++numIntParams;
                        continue;
                    }
                    ++numDoubleParams;
                    continue;
                }
                ++otherParams;
            }
        }
        stats.put((Object)"nComponents", (Object)numComponents);
        stats.put((Object)"nNumericParameters", (Object)numNumericParams);
        stats.put((Object)"nIntegerParameters", (Object)numIntParams);
        stats.put((Object)"nContinuousParameters", (Object)numDoubleParams);
        stats.put((Object)"nCategoricalParameters", (Object)numCatParams);
        stats.put((Object)"nBooleanParameters", (Object)numBoolParams);
        stats.put((Object)"nOtherParameters", (Object)otherParams);
        return stats;
    }

    public static Collection<IComponent> getAffectedComponents(Collection<? extends IComponent> components, String requiredInterface) {
        HashSet<IComponent> affectedComponents = new HashSet<IComponent>(ComponentUtil.getComponentsProvidingInterface(components, requiredInterface));
        if (affectedComponents.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve the requiredInterface " + requiredInterface);
        }
        HashSet recursiveResolvedComps = new HashSet();
        affectedComponents.forEach(x -> x.getRequiredInterfaces().stream().map(iface -> ComponentUtil.getAffectedComponents(components, iface.getName())).forEach(recursiveResolvedComps::addAll));
        affectedComponents.addAll(recursiveResolvedComps);
        return affectedComponents;
    }

    public static IComponent getComponentByName(String componentName, Collection<? extends IComponent> components) throws ComponentNotFoundException {
        for (IComponent iComponent : components) {
            if (!iComponent.getName().equals(componentName)) continue;
            return iComponent;
        }
        throw new ComponentNotFoundException("No Component with this name loaded: " + componentName);
    }
}

