/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfiguration;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.api.IParameterDependency;
import ai.libs.jaicore.components.api.IParameterDomain;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositionProblemUtil {
    private static final Logger logger = LoggerFactory.getLogger(CompositionProblemUtil.class);

    private CompositionProblemUtil() {
    }

    public static Collection<IComponent> getComponentsThatResolveProblem(SoftwareConfigurationProblem<?> configurationProblem) {
        return CompositionProblemUtil.getComponentsThatProvideInterface(configurationProblem, configurationProblem.getRequiredInterface());
    }

    public static Collection<IComponent> getComponentsThatProvideInterface(SoftwareConfigurationProblem<?> configurationProblem, String requiredInterface) {
        return configurationProblem.getComponents().stream().filter(c -> c.getProvidedInterfaces().contains(requiredInterface)).collect(Collectors.toList());
    }

    public static List<IComponentInstance> getComponentInstancesOfComposition(IComponentInstance composition) {
        LinkedList<IComponentInstance> components = new LinkedList<IComponentInstance>();
        ArrayDeque<IComponentInstance> componentInstances = new ArrayDeque<IComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            IComponentInstance curInstance = (IComponentInstance)componentInstances.pop();
            components.add(curInstance);
            for (Collection collection : curInstance.getSatisfactionOfRequiredInterfaces().values()) {
                collection.forEach(componentInstances::push);
            }
        }
        return components;
    }

    public static String getComponentNamesOfComposition(IComponentInstance composition) {
        StringBuilder builder = new StringBuilder();
        ArrayDeque<IComponentInstance> componentInstances = new ArrayDeque<IComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            IComponentInstance curInstance = (IComponentInstance)componentInstances.pop();
            builder.append(curInstance.getComponent().getName());
            if (curInstance.getSatisfactionOfRequiredInterfaces() == null) continue;
            for (Collection collection : curInstance.getSatisfactionOfRequiredInterfaces().values()) {
                collection.forEach(componentInstances::push);
            }
        }
        return builder.toString();
    }

    public static List<IComponent> getComponentsOfComposition(IComponentInstance composition) {
        LinkedList<IComponent> components = new LinkedList<IComponent>();
        ArrayDeque<IComponentInstance> componentInstances = new ArrayDeque<IComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            IComponentInstance curInstance = (IComponentInstance)componentInstances.pop();
            components.add(curInstance.getComponent());
            for (Collection collection : curInstance.getSatisfactionOfRequiredInterfaces().values()) {
                collection.forEach(componentInstances::push);
            }
        }
        return components;
    }

    public static boolean isDependencyPremiseSatisfied(IParameterDependency dependency, Map<IParameter, IParameterDomain> values) {
        logger.debug("Checking satisfcation of dependency {} with values {}", (Object)dependency, values);
        for (Collection<Pair<IParameter, IParameterDomain>> condition : dependency.getPremise()) {
            boolean check = CompositionProblemUtil.isDependencyConditionSatisfied(condition, values);
            logger.trace("Result of check for condition {}: {}", condition, (Object)check);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static boolean isDependencyConditionSatisfied(Collection<Pair<IParameter, IParameterDomain>> condition, Map<IParameter, IParameterDomain> values) {
        for (Pair<IParameter, IParameterDomain> conditionItem : condition) {
            IParameterDomain actualDomain;
            IParameter param = (IParameter)conditionItem.getX();
            if (!values.containsKey(param)) {
                throw new IllegalArgumentException("Cannot check condition " + condition + " as the value for parameter " + param.getName() + " is not defined in " + values);
            }
            if (values.get(param) == null) {
                throw new IllegalArgumentException("Cannot check condition " + condition + " as the value for parameter " + param.getName() + " is NULL in " + values);
            }
            IParameterDomain requiredDomain = (IParameterDomain)conditionItem.getY();
            if (requiredDomain.subsumes(actualDomain = values.get(param))) continue;
            return false;
        }
        return true;
    }

    public static List<Interval> getNumericParameterRefinement(Interval interval, double focus, boolean integer, INumericParameterRefinementConfiguration refinementConfig) {
        double sup;
        double inf = interval.getInf();
        if (inf == (sup = interval.getSup())) {
            return new ArrayList<Interval>();
        }
        if (integer && Math.floor(sup) - Math.ceil(inf) + 1.0 <= (double)refinementConfig.getRefinementsPerStep()) {
            ArrayList<Interval> proposedRefinements = new ArrayList<Interval>();
            for (int i = (int)Math.ceil(inf); i <= (int)Math.floor(sup); ++i) {
                proposedRefinements.add(new Interval((double)i, (double)i));
            }
            return proposedRefinements;
        }
        if (sup - inf < refinementConfig.getIntervalLength()) {
            return new ArrayList<Interval>();
        }
        if (!refinementConfig.isInitRefinementOnLogScale()) {
            List<Interval> proposedRefinements = CompositionProblemUtil.refineOnLinearScale(interval, refinementConfig.getRefinementsPerStep(), refinementConfig.getIntervalLength());
            for (Interval proposedRefinement : proposedRefinements) {
                assert (proposedRefinement.getInf() >= inf && proposedRefinement.getSup() <= sup) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of [" + inf + ", " + sup + "].";
                if (!proposedRefinement.equals(interval)) continue;
                throw new IllegalStateException("No real refinement! Intervals are identical.");
            }
            return proposedRefinements;
        }
        List<Interval> proposedRefinements = CompositionProblemUtil.refineOnLogScale(interval, refinementConfig.getRefinementsPerStep(), 2.0, focus);
        for (Interval proposedRefinement : proposedRefinements) {
            double epsilon = 1.0E-7;
            assert (proposedRefinement.getInf() + epsilon >= inf && proposedRefinement.getSup() <= sup + epsilon) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of [" + inf + ", " + sup + "].";
            if (!proposedRefinement.equals(interval)) continue;
            throw new IllegalStateException("No real refinement! Intervals are identical.");
        }
        return proposedRefinements;
    }

    public static List<Interval> refineOnLinearScale(Interval interval, int maxNumberOfSubIntervals, double minimumLengthOfIntervals) {
        double min = interval.getInf();
        double max = interval.getSup();
        double length = max - min;
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        if (length <= minimumLengthOfIntervals) {
            intervals.add(interval);
            return intervals;
        }
        int numberOfIntervals = Math.min((int)Math.ceil(length / minimumLengthOfIntervals), maxNumberOfSubIntervals);
        double stepSize = length / (double)numberOfIntervals;
        for (int i = 0; i < numberOfIntervals; ++i) {
            intervals.add(new Interval(min + (double)i * stepSize, min + (double)(i + 1) * stepSize));
        }
        return intervals;
    }

    public static List<Interval> refineOnLogScale(Interval interval, int n, double basis, double pointOfConcentration) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        double min = interval.getInf();
        double max = interval.getSup();
        double length = max - min;
        if (pointOfConcentration <= min || pointOfConcentration >= max) {
            double lengthOfShortestInterval = length * (1.0 - basis) / (1.0 - Math.pow(basis, n));
            if (pointOfConcentration <= min) {
                double endOfLast = min;
                for (int i = 0; i < n; ++i) {
                    double start = endOfLast;
                    endOfLast = start + Math.pow(basis, i) * lengthOfShortestInterval;
                    list.add(new Interval(start, endOfLast));
                }
            } else {
                double endOfLast = max;
                for (int i = 0; i < n; ++i) {
                    double start = endOfLast;
                    endOfLast = start - Math.pow(basis, i) * lengthOfShortestInterval;
                    list.add(new Interval(endOfLast, start));
                }
                Collections.reverse(list);
            }
            return list;
        }
        double distanceFromMinToFocus = Math.abs(interval.getInf() - pointOfConcentration);
        int segmentsForLeft = (int)Math.max(1.0, Math.floor((double)n * distanceFromMinToFocus / length));
        int segmentsForRight = n - segmentsForLeft;
        list.addAll(CompositionProblemUtil.refineOnLogScale(new Interval(min, pointOfConcentration), segmentsForLeft, basis, pointOfConcentration));
        list.addAll(CompositionProblemUtil.refineOnLogScale(new Interval(pointOfConcentration, max), segmentsForRight, basis, pointOfConcentration));
        return list;
    }

    public static void refineRecursively(Interval interval, int maxNumberOfSubIntervalsPerRefinement, double basis, double pointOfConcentration, double factorForMaximumLengthOfFinestIntervals) {
        List<Interval> initRefinement = CompositionProblemUtil.refineOnLogScale(interval, maxNumberOfSubIntervalsPerRefinement, basis, pointOfConcentration);
        Collections.reverse(initRefinement);
        LinkedList<Interval> openRefinements = new LinkedList<Interval>();
        openRefinements.addAll(initRefinement);
        int depth = 0;
        do {
            Interval intervalToRefine = (Interval)openRefinements.pop();
            if (logger.isInfoEnabled()) {
                StringBuilder offsetSB = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    offsetSB.append("\t");
                }
                logger.info("{}[{}, {}]", new Object[]{offsetSB, intervalToRefine.getInf(), intervalToRefine.getSup()});
            }
            double distanceToPointOfContentration = Math.min(Math.abs(intervalToRefine.getInf() - pointOfConcentration), Math.abs(intervalToRefine.getSup() - pointOfConcentration));
            double maximumLengthOfFinestIntervals = Math.pow(distanceToPointOfContentration + 1.0, 2.0) * factorForMaximumLengthOfFinestIntervals;
            logger.info("{} * {} = {}", new Object[]{Math.pow(distanceToPointOfContentration + 1.0, 2.0), factorForMaximumLengthOfFinestIntervals, maximumLengthOfFinestIntervals});
            List<Interval> refinements = CompositionProblemUtil.refineOnLinearScale(intervalToRefine, maxNumberOfSubIntervalsPerRefinement, maximumLengthOfFinestIntervals);
            ++depth;
            if (refinements.size() == 1 && refinements.get(0).equals(intervalToRefine)) {
                --depth;
                continue;
            }
            Collections.reverse(refinements);
            openRefinements.addAll(refinements);
        } while (!openRefinements.isEmpty());
    }
}

