/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.api.INumericParameterRefinementConfiguration;

public class NumericParameterRefinementConfiguration
implements INumericParameterRefinementConfiguration {
    private final boolean initRefinementOnLogScale;
    private final double focusPoint;
    private final double logBasis;
    private final boolean initWithExtremalPoints;
    private final int refinementsPerStep;
    private final double intervalLength;

    public NumericParameterRefinementConfiguration(boolean initWithExtremalPoints, int refinementsPerStep, double intervalLength) {
        this(Double.NaN, 0.0, initWithExtremalPoints, refinementsPerStep, intervalLength);
    }

    public NumericParameterRefinementConfiguration(double focusPoint, double logBasis, boolean initWithExtremalPoints, int refinementsPerStep, double intervalLength) {
        if (intervalLength <= 0.0) {
            throw new IllegalArgumentException("Interval length must be strictly positive but is " + intervalLength);
        }
        this.focusPoint = focusPoint;
        this.logBasis = logBasis;
        this.initRefinementOnLogScale = !Double.isNaN(focusPoint);
        this.initWithExtremalPoints = initWithExtremalPoints;
        this.refinementsPerStep = refinementsPerStep;
        this.intervalLength = intervalLength;
    }

    @Override
    public boolean isInitRefinementOnLogScale() {
        return this.initRefinementOnLogScale;
    }

    @Override
    public double getFocusPoint() {
        return this.focusPoint;
    }

    @Override
    public double getLogBasis() {
        return this.logBasis;
    }

    @Override
    public boolean isInitWithExtremalPoints() {
        return this.initWithExtremalPoints;
    }

    @Override
    public int getRefinementsPerStep() {
        return this.refinementsPerStep;
    }

    @Override
    public double getIntervalLength() {
        return this.intervalLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[InitiallyLogScale:");
        sb.append(this.initRefinementOnLogScale);
        sb.append(",RefinementsPerStep:");
        sb.append(this.refinementsPerStep);
        sb.append(",intervalLength:");
        sb.append(this.intervalLength);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.focusPoint);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.initRefinementOnLogScale ? 1231 : 1237);
        result = 31 * result + (this.initWithExtremalPoints ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.intervalLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.logBasis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.refinementsPerStep;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericParameterRefinementConfiguration other = (NumericParameterRefinementConfiguration)obj;
        if (Double.doubleToLongBits(this.focusPoint) != Double.doubleToLongBits(other.focusPoint)) {
            return false;
        }
        if (this.initRefinementOnLogScale != other.initRefinementOnLogScale) {
            return false;
        }
        if (this.initWithExtremalPoints != other.initWithExtremalPoints) {
            return false;
        }
        if (Double.doubleToLongBits(this.intervalLength) != Double.doubleToLongBits(other.intervalLength)) {
            return false;
        }
        if (Double.doubleToLongBits(this.logBasis) != Double.doubleToLongBits(other.logBasis)) {
            return false;
        }
        return this.refinementsPerStep == other.refinementsPerStep;
    }
}

