/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.api.IParameterDomain;
import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;

@JsonPropertyOrder(value={"name", "defaultDomain", "defaultValue"})
public class Parameter
implements IParameter,
Serializable {
    private static final long serialVersionUID = 8735407907221383716L;
    private final String name;
    private final IParameterDomain defaultDomain;
    private final Serializable defaultValue;

    private Parameter() {
        this.name = null;
        this.defaultDomain = null;
        this.defaultValue = null;
    }

    @JsonCreator
    public Parameter(@JsonProperty(value="name") String name, @JsonProperty(value="defaultDomain") IParameterDomain defaultDomain, @JsonProperty(value="defaultValue") Serializable defaultValue) {
        this.name = name;
        this.defaultDomain = defaultDomain;
        if (!defaultDomain.contains(defaultValue)) {
            throw new IllegalArgumentException("The domain provided for parameter " + name + " is " + defaultDomain + " and does not contain the assigned default value " + defaultValue);
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IParameterDomain getDefaultDomain() {
        return this.defaultDomain;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue(Object value) {
        return this.defaultDomain.isEquals(this.defaultValue, value);
    }

    @Override
    public boolean isNumeric() {
        return this.defaultDomain instanceof NumericParameterDomain;
    }

    @Override
    public boolean isCategorical() {
        return this.defaultDomain instanceof CategoricalParameterDomain;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultDomain == null ? 0 : this.defaultDomain.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.defaultDomain == null ? other.defaultDomain != null : !this.defaultDomain.equals(other.defaultDomain)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

