/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfiguration;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfigurationMap;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.components.serialization.ComponentSerialization;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.api4.java.common.attributedobjects.IObjectEvaluator;

public class RefinementConfiguredSoftwareConfigurationProblem<V extends Comparable<V>>
extends SoftwareConfigurationProblem<V> {
    private final INumericParameterRefinementConfigurationMap paramRefinementConfig;

    public RefinementConfiguredSoftwareConfigurationProblem(Collection<? extends IComponent> components, String requiredInterface, IObjectEvaluator<IComponentInstance, V> compositionEvaluator, INumericParameterRefinementConfigurationMap paramRefinementConfig) {
        this(new SoftwareConfigurationProblem<V>(components, requiredInterface, compositionEvaluator), paramRefinementConfig);
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, Collection<? extends IComponent> components, INumericParameterRefinementConfigurationMap paramRefinementConfig) {
        this(components, problemTemplate.getRequiredInterface(), problemTemplate.getCompositionEvaluator(), paramRefinementConfig);
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, IObjectEvaluator<IComponentInstance, V> evaluator) {
        this(problemTemplate.getComponents(), problemTemplate.getRequiredInterface(), evaluator, problemTemplate.getParamRefinementConfig());
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, String requiredInterface) {
        this(problemTemplate.getComponents(), requiredInterface, problemTemplate.getCompositionEvaluator(), problemTemplate.getParamRefinementConfig());
    }

    public RefinementConfiguredSoftwareConfigurationProblem(File configurationFile, String requiredInterface, IObjectEvaluator<IComponentInstance, V> compositionEvaluator) throws IOException {
        super(configurationFile, requiredInterface, compositionEvaluator);
        this.paramRefinementConfig = new ComponentSerialization().deserializeParamMap(configurationFile);
        for (IComponent c : this.getComponents()) {
            for (IParameter p : c.getParameters()) {
                if (!p.isNumeric()) continue;
                if (this.paramRefinementConfig.getRefinement(c, p) == null) {
                    throw new IllegalArgumentException("Error in parsing config file " + configurationFile.getAbsolutePath() + ". No refinement config was delivered for numeric parameter " + p.getName() + " of component " + c.getName());
                }
                NumericParameterDomain domain = (NumericParameterDomain)p.getDefaultDomain();
                INumericParameterRefinementConfiguration refinementConfig = this.paramRefinementConfig.getRefinement(c, p);
                double range = domain.getMax() - domain.getMin();
                if (!(range > 0.0) || !(refinementConfig.getIntervalLength() >= range)) continue;
                throw new IllegalArgumentException("Error in parsing config file " + configurationFile.getAbsolutePath() + ". The defined interval length " + refinementConfig.getIntervalLength() + " for parameter " + p.getName() + " of component " + c.getName() + " is not strictly smaller than the parameter range " + (domain.getMax() - domain.getMin()) + " of interval [" + domain.getMin() + ", " + domain.getMax() + "]. No refinement is possible hence.");
            }
        }
    }

    public RefinementConfiguredSoftwareConfigurationProblem(SoftwareConfigurationProblem<V> coreProblem, INumericParameterRefinementConfigurationMap paramRefinementConfig) {
        super(coreProblem);
        this.paramRefinementConfig = paramRefinementConfig;
    }

    public INumericParameterRefinementConfigurationMap getParamRefinementConfig() {
        return this.paramRefinementConfig;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + (this.paramRefinementConfig == null ? 0 : this.paramRefinementConfig.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefinementConfiguredSoftwareConfigurationProblem other = (RefinementConfiguredSoftwareConfigurationProblem)obj;
        return !(this.paramRefinementConfig == null ? other.paramRefinementConfig != null : !this.paramRefinementConfig.equals(other.paramRefinementConfig));
    }
}

