/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.serialization;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstance;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ComponentInstanceDeserializer
extends StdDeserializer<ComponentInstance> {
    private static final long serialVersionUID = 4216559441244072999L;
    private transient Collection<IComponent> possibleComponents;

    public ComponentInstanceDeserializer(Collection<? extends IComponent> possibleComponents) {
        super(ComponentInstance.class);
        this.possibleComponents = new ArrayList<IComponent>(possibleComponents);
    }

    public ComponentInstance readFromJson(String json) throws IOException {
        return this.readAsTree(new ObjectMapper().readTree(json));
    }

    public ComponentInstance readAsTree(JsonNode p) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameterValues = new HashMap();
        if (p.has("params")) {
            parameterValues = (Map)mapper.treeToValue((TreeNode)p.get("params"), HashMap.class);
        }
        String componentName = p.get("component").toString().replace("\"", "");
        IComponent component = this.possibleComponents.stream().filter(c -> c.getName().equals(componentName)).findFirst().orElseThrow(NoSuchElementException::new);
        HashMap<String, List<IComponentInstance>> satisfactionOfRequiredInterfaces = new HashMap<String, List<IComponentInstance>>();
        JsonNode n = p.get("requiredInterfaces");
        if (n != null) {
            Iterator fields = n.fieldNames();
            while (fields.hasNext()) {
                String key = (String)fields.next();
                ArrayNode provisions = (ArrayNode)n.get(key);
                ArrayList<ComponentInstance> componentInstances = new ArrayList<ComponentInstance>();
                for (JsonNode ci : provisions) {
                    componentInstances.add(this.readAsTree(ci));
                }
                satisfactionOfRequiredInterfaces.put(key, componentInstances);
            }
        }
        return new ComponentInstance(component, parameterValues, satisfactionOfRequiredInterfaces);
    }

    public ComponentInstance deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.readAsTree((JsonNode)p.readValueAsTree());
    }
}

