/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.document;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class TextBlock
implements Cloneable {
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final TextBlock EMPTY_START = new TextBlock("", EMPTY_BITSET, 0, 0, 0, 0, -1);
    public static final TextBlock EMPTY_END = new TextBlock("", EMPTY_BITSET, 0, 0, 0, 0, Integer.MAX_VALUE);
    private boolean isContent = false;
    private CharSequence text;
    private CharSequence richText;
    private Set<String> labels = new HashSet<String>(2);
    private int offsetBlocksStart;
    private int offsetBlocksEnd;
    private int numWords;
    private int numWordsInAnchorText;
    private int numWordsInWrappedLines;
    private int numWrappedLines;
    private float textDensity;
    private float linkDensity;
    private BitSet containedTextElements;
    private int numFullTextWords = 0;
    private int tagLevel;
    private String cssSelector;

    public TextBlock(String text) {
        this(text, null, 0, 0, 0, 0, 0);
    }

    public TextBlock(String text, BitSet containedTextElements, int numWords, int numWordsInAnchorText, int numWordsInWrappedLines, int numWrappedLines, int offsetBlocks) {
        this.text = text;
        this.richText = text.length() > 1 ? "<p>" + text + "</p>\n" : "";
        this.containedTextElements = containedTextElements;
        this.numWords = numWords;
        this.numWordsInAnchorText = numWordsInAnchorText;
        this.numWordsInWrappedLines = numWordsInWrappedLines;
        this.numWrappedLines = numWrappedLines;
        this.offsetBlocksStart = offsetBlocks;
        this.offsetBlocksEnd = offsetBlocks;
        this.initDensities();
    }

    public boolean isContent() {
        return this.isContent;
    }

    public boolean setIsContent(boolean isContent) {
        if (isContent != this.isContent) {
            this.isContent = isContent;
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text.toString();
    }

    public String getRichText() {
        return this.richText.toString();
    }

    public int getNumWords() {
        return this.numWords;
    }

    public int getNumWordsInAnchorText() {
        return this.numWordsInAnchorText;
    }

    public float getTextDensity() {
        return this.textDensity;
    }

    public float getLinkDensity() {
        return this.linkDensity;
    }

    public String getCssSelector() {
        return this.cssSelector;
    }

    public void setCssSelector(String cssSelector) {
        this.cssSelector = cssSelector;
    }

    public void mergeNext(TextBlock other) {
        if (!(this.text instanceof StringBuilder)) {
            this.text = new StringBuilder(this.text);
        }
        if (!(this.richText instanceof StringBuilder)) {
            this.richText = new StringBuilder(this.richText);
        }
        StringBuilder sb = (StringBuilder)this.text;
        StringBuilder richSb = (StringBuilder)this.richText;
        String copy = other.text.toString();
        sb.append('\n');
        sb.append(copy);
        if (copy.length() > 1) {
            richSb.append("<p>");
            richSb.append(copy);
            richSb.append("</p>\n");
        }
        this.numWords += other.numWords;
        this.numWordsInAnchorText += other.numWordsInAnchorText;
        this.numWordsInWrappedLines += other.numWordsInWrappedLines;
        this.numWrappedLines += other.numWrappedLines;
        this.offsetBlocksStart = Math.min(this.offsetBlocksStart, other.offsetBlocksStart);
        this.offsetBlocksEnd = Math.max(this.offsetBlocksEnd, other.offsetBlocksEnd);
        this.initDensities();
        this.isContent |= other.isContent;
        if (this.containedTextElements == null) {
            this.containedTextElements = (BitSet)other.containedTextElements.clone();
        } else {
            this.containedTextElements.or(other.containedTextElements);
        }
        this.numFullTextWords += other.numFullTextWords;
        if (other.labels != null) {
            if (this.labels == null) {
                this.labels = new HashSet<String>(other.labels);
            } else {
                this.labels.addAll(other.labels);
            }
        }
        this.tagLevel = Math.min(this.tagLevel, other.tagLevel);
    }

    private void initDensities() {
        if (this.numWordsInWrappedLines == 0) {
            this.numWordsInWrappedLines = this.numWords;
            this.numWrappedLines = 1;
        }
        this.textDensity = (float)this.numWordsInWrappedLines / (float)this.numWrappedLines;
        this.linkDensity = this.numWords == 0 ? 0.0f : (float)this.numWordsInAnchorText / (float)this.numWords;
    }

    public int getOffsetBlocksStart() {
        return this.offsetBlocksStart;
    }

    public int getOffsetBlocksEnd() {
        return this.offsetBlocksEnd;
    }

    public String toString() {
        return "[" + this.offsetBlocksStart + "-" + this.offsetBlocksEnd + ";tl=" + this.tagLevel + "; nw=" + this.numWords + ";nwl=" + this.numWrappedLines + ";ld=" + this.linkDensity + "]\tselector=" + this.getCssSelector() + ";\t" + (this.isContent ? "CONTENT" : "boilerplate") + "," + this.labels + "\n" + this.getText();
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public boolean hasLabel(String label) {
        return this.labels != null && this.labels.contains(label);
    }

    public boolean removeLabel(String label) {
        return this.labels != null && this.labels.remove(label);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void addLabels(Set<String> l) {
        if (l == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashSet<String>(l);
        } else {
            this.labels.addAll(l);
        }
    }

    public void addLabels(String ... l) {
        if (l == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashSet<String>();
        }
        for (String label : l) {
            this.labels.add(label);
        }
    }

    public BitSet getContainedTextElements() {
        return this.containedTextElements;
    }

    protected TextBlock clone() {
        TextBlock clone;
        try {
            clone = (TextBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.text != null && !(this.text instanceof String)) {
            clone.text = new StringBuilder(this.text);
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            clone.labels = new HashSet<String>(this.labels);
        }
        if (this.containedTextElements != null) {
            clone.containedTextElements = (BitSet)this.containedTextElements.clone();
        }
        return clone;
    }

    public int getTagLevel() {
        return this.tagLevel;
    }

    public void setTagLevel(int tagLevel) {
        this.tagLevel = tagLevel;
    }
}

