/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.document;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.utils.PageCategory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TextDocument
implements Cloneable {
    private final List<TextBlock> textBlocks;
    private String baseUrl;
    private String pageTitle;
    private String contentTitle;
    private Instant publishTime = Instant.EPOCH;
    private Instant modifiedTime = Instant.EPOCH;
    private int dateTimeCount = 0;
    private Stat stat = new Stat();
    private PageCategory pageCategory = PageCategory.UNKNOWN;
    private Map<String, String> fields = new LinkedHashMap<String, String>();

    public TextDocument(String baseUrl, String pageTitle, List<TextBlock> textBlocks) {
        this.baseUrl = baseUrl;
        this.pageTitle = pageTitle;
        this.textBlocks = textBlocks;
    }

    public List<TextBlock> getTextBlocks() {
        return this.textBlocks;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPageTitle() {
        return this.pageTitle == null ? "" : this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getContentTitle() {
        return this.contentTitle == null ? "" : this.contentTitle;
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }

    public Instant getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(Instant publishTime) {
        this.publishTime = publishTime;
    }

    public Instant getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Instant modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public int getDateTimeCount() {
        return this.dateTimeCount;
    }

    public void setDateTimeCount(int dateTimeCount) {
        this.dateTimeCount = dateTimeCount;
    }

    public void setStat(Stat stat) {
        this.stat = stat;
    }

    public Stat getStat() {
        return this.stat;
    }

    public PageCategory getPageCategory() {
        return this.pageCategory;
    }

    public String getPageCategoryAsString() {
        return this.pageCategory.toString();
    }

    public void setPageCategory(PageCategory pageCategory) {
        this.pageCategory = pageCategory;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return this.fields.get(name);
    }

    public String getFieldOrDefault(String name, String defaultValue) {
        return this.fields.getOrDefault(name, defaultValue);
    }

    public void setField(String name, String value) {
        this.fields.put(name, value);
    }

    public String getTextContent() {
        return this.getTextContent(true, false);
    }

    public String getTextContent(boolean includeContent, boolean includeNonContent) {
        StringBuilder sb = new StringBuilder();
        for (TextBlock block : this.getTextBlocks()) {
            if (block.isContent() ? !includeContent : !includeNonContent) continue;
            sb.append(block.getText());
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getHtmlContent() {
        return this.getHtmlContent(true, false);
    }

    public String getHtmlContent(boolean includeContent, boolean includeNonContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        for (TextBlock block : this.getTextBlocks()) {
            if ((!block.isContent() ? !includeNonContent : !includeContent) || block.getRichText().length() <= 1) continue;
            sb.append("<div>");
            sb.append(block.getRichText());
            sb.append("</div>\n");
        }
        sb.append("</div>");
        return sb.toString();
    }

    public String debugString() {
        StringBuilder sb = new StringBuilder();
        for (TextBlock tb : this.getTextBlocks()) {
            if (!tb.getLabels().isEmpty()) {
                sb.append("[LABLE : " + tb.getLabels() + "]");
            }
            sb.append(tb.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public TextDocument clone() {
        ArrayList<TextBlock> list = new ArrayList<TextBlock>(this.textBlocks.size());
        for (TextBlock tb : this.textBlocks) {
            list.add(tb.clone());
        }
        return new TextDocument(this.baseUrl, this.pageTitle, list);
    }

    public class Stat {
        public int _char = 0;
        public int _a = 0;
        public int _img = 0;
    }
}

