/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.extractors;

import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.extractors.TextExtractor;
import ai.platon.pulsar.boilerpipe.filters.heuristics.BlockProximityFusion;
import ai.platon.pulsar.boilerpipe.filters.heuristics.DocumentTitleMatchClassifier;
import ai.platon.pulsar.boilerpipe.filters.heuristics.ExpandTitleToContentFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.IgnoreBlocksAfterContentFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.KeepLargestBlockFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.LargeBlockSameTagLevelToContentFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.ListAtEndFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.TerminatingBlocksFinder;
import ai.platon.pulsar.boilerpipe.filters.heuristics.TrailingHeadlineToBoilerplateFilter;
import ai.platon.pulsar.boilerpipe.filters.simple.BoilerplateBlockFilter;
import ai.platon.pulsar.boilerpipe.filters.statistics.NumWordsRulesClassifier;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public final class ArticleExtractor
implements TextExtractor {
    public static final ArticleExtractor INSTANCE = new ArticleExtractor();

    public static ArticleExtractor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        return TerminatingBlocksFinder.INSTANCE.process(doc) | new DocumentTitleMatchClassifier(doc.getPageTitle()).process(doc) | NumWordsRulesClassifier.INSTANCE.process(doc) | IgnoreBlocksAfterContentFilter.DEFAULT_INSTANCE.process(doc) | TrailingHeadlineToBoilerplateFilter.INSTANCE.process(doc) | BlockProximityFusion.MAX_DISTANCE_1.process(doc) | BoilerplateBlockFilter.INSTANCE_KEEP_TITLE.process(doc) | BlockProximityFusion.MAX_DISTANCE_1_CONTENT_ONLY_SAME_TAGLEVEL.process(doc) | KeepLargestBlockFilter.INSTANCE_EXPAND_TO_SAME_TAGLEVEL_MIN_WORDS.process(doc) | ExpandTitleToContentFilter.INSTANCE.process(doc) | LargeBlockSameTagLevelToContentFilter.INSTANCE.process(doc) | ListAtEndFilter.INSTANCE.process(doc);
    }
}

